/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.market.StreamFailureListener;
import net.quedex.api.pgp.BcEncryptor;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.PGPExceptionBase;
import net.quedex.api.user.OrderSpec;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UserMessageSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserMessageSender.class);
    private static final ObjectMapper OBJECT_MAPPER = MessageReceiver.OBJECT_MAPPER;
    private static final ObjectWriter OBJECT_WRITER = OBJECT_MAPPER.writer();
    private final WebSocketClient webSocketClient;
    private final BcEncryptor encryptor;
    private final long accountId;
    private final int nonceGroup;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private volatile StreamFailureListener streamFailureListener;
    private volatile long nonce;

    UserMessageSender(WebSocketClient webSocketClient, long accountId, int nonceGroup, BcPublicKey publicKey, BcPrivateKey privateKey) {
        Preconditions.checkArgument((nonceGroup >= 0 ? 1 : 0) != 0, (String)"nonceGroup=%s < 0", (Object[])new Object[]{nonceGroup});
        Preconditions.checkArgument((accountId > 0L ? 1 : 0) != 0, (String)"accountId=%s <= 0", (Object[])new Object[]{accountId});
        this.webSocketClient = (WebSocketClient)Preconditions.checkNotNull((Object)webSocketClient, (Object)"null webSocketClient");
        this.encryptor = new BcEncryptor(publicKey, privateKey);
        this.accountId = accountId;
        this.nonceGroup = nonceGroup;
    }

    void registerStreamFailureListener(StreamFailureListener streamFailureListener) {
        this.streamFailureListener = streamFailureListener;
    }

    void setStartNonce(long startNonce) {
        LOGGER.debug("setStartNonce({})", (Object)startNonce);
        this.nonce = startNonce;
    }

    void sendGetLastNonce() throws CommunicationException {
        try {
            this.sendMessage((JsonNode)OBJECT_MAPPER.createObjectNode().put("type", "get_last_nonce").put("nonce_group", this.nonceGroup).put("account_id", this.accountId));
        }
        catch (JsonProcessingException | PGPExceptionBase e) {
            throw new CommunicationException("Error sending get_last_nonce", e);
        }
    }

    void sendSubscribe() {
        this.sendMessageQueued(() -> this.addNonceAccountId(OBJECT_MAPPER.createObjectNode().put("type", "subscribe")));
    }

    void sendOrderSpec(OrderSpec orderSpec) {
        this.sendMessageQueued(() -> this.addNonceAccountId((ObjectNode)OBJECT_MAPPER.valueToTree((Object)orderSpec)));
    }

    void sendBatch(List<OrderSpec> batch) {
        this.sendMessageQueued(() -> {
            JsonNode batchJson = OBJECT_MAPPER.valueToTree((Object)batch);
            for (JsonNode node : batchJson) {
                Preconditions.checkState((boolean)(node instanceof ObjectNode), (Object)"Expected ObjectNode");
                this.addNonceAccountId((ObjectNode)node);
            }
            return OBJECT_MAPPER.createObjectNode().put("type", "batch").put("account_id", this.accountId).set("batch", batchJson);
        });
    }

    void stop() {
        this.executor.shutdown();
    }

    private void sendMessageQueued(Supplier<JsonNode> supplier) {
        this.executor.execute(() -> {
            try {
                this.sendMessage((JsonNode)supplier.get());
            }
            catch (Exception e) {
                this.onError(new CommunicationException("Error sending message", e));
            }
        });
    }

    private ObjectNode addNonceAccountId(ObjectNode jsonMessage) {
        return jsonMessage.put("account_id", this.accountId).put("nonce", this.getNonce()).put("nonce_group", this.nonceGroup);
    }

    private long getNonce() {
        return ++this.nonce;
    }

    private void sendMessage(JsonNode jsonMessage) throws JsonProcessingException, PGPExceptionBase {
        String messageStr = OBJECT_WRITER.writeValueAsString((Object)jsonMessage);
        this.webSocketClient.send(this.encryptor.encrypt(messageStr, true));
        LOGGER.trace("sendMessage({})", (Object)messageStr);
    }

    private void onError(Exception e) {
        LOGGER.warn("onError({})", (Throwable)e);
        StreamFailureListener streamFailureListener = this.streamFailureListener;
        if (streamFailureListener != null) {
            streamFailureListener.onStreamFailure(e);
        }
    }
}

