/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.market;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.quedex.api.common.MessageReceiver;
import net.quedex.api.market.Instrument;
import net.quedex.api.market.InstrumentsListener;
import net.quedex.api.market.OrderBook;
import net.quedex.api.market.OrderBookListener;
import net.quedex.api.market.Quotes;
import net.quedex.api.market.QuotesListener;
import net.quedex.api.market.Registration;
import net.quedex.api.market.SessionState;
import net.quedex.api.market.SessionStateListener;
import net.quedex.api.market.Trade;
import net.quedex.api.market.TradeListener;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.pgp.BcSignatureVerifier;
import net.quedex.api.pgp.PGPExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MarketMessageReceiver
extends MessageReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarketMessageReceiver.class);
    private final BcSignatureVerifier bcSignatureVerifier;
    private volatile InstrumentsListener instrumentsListener;
    private final Object instrumentsMonitor = new Object();
    private Map<Integer, Instrument> instrumentsCached;
    private volatile OrderBookListener orderBookListener;
    private final Set<Integer> orderBookSubscriptions = new HashSet<Integer>(64, 0.75f);
    private final Map<Integer, OrderBook> orderBookCache = new HashMap<Integer, OrderBook>(64, 0.75f);
    private volatile TradeListener tradeListener;
    private final Set<Integer> tradeSubscriptions = new HashSet<Integer>(64, 0.75f);
    private final Map<Integer, Trade> tradeCache = new HashMap<Integer, Trade>(64, 0.75f);
    private volatile QuotesListener quotesListener;
    private final Set<Integer> quotesSubscriptions = new HashSet<Integer>(64, 0.75f);
    private final Map<Integer, Quotes> quotesCache = new HashMap<Integer, Quotes>(64, 0.75f);
    private volatile SessionStateListener sessionStateListener;
    private final Object sessionStateMonitor = new Object();
    private SessionState sessionStateCached;

    MarketMessageReceiver(BcPublicKey qdxPublicKey) {
        super(LOGGER);
        this.bcSignatureVerifier = new BcSignatureVerifier(qdxPublicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerInstrumentsListener(InstrumentsListener instrumentsListener) {
        this.instrumentsListener = instrumentsListener;
        Object object = this.instrumentsMonitor;
        synchronized (object) {
            Map<Integer, Instrument> instrumentsCached = this.instrumentsCached;
            if (instrumentsListener != null && instrumentsCached != null) {
                instrumentsListener.onInstruments(instrumentsCached);
            }
        }
    }

    Registration registerOrderBookListener(final OrderBookListener orderBookListener) {
        this.orderBookListener = orderBookListener;
        return new CachedRegistration<OrderBook>(this.orderBookSubscriptions, this.orderBookCache){

            @Override
            void onSubscribe(OrderBook element) {
                if (orderBookListener != null) {
                    orderBookListener.onOrderBook(element);
                }
            }
        };
    }

    Registration registerTradeListener(final TradeListener tradeListener) {
        this.tradeListener = tradeListener;
        return new CachedRegistration<Trade>(this.tradeSubscriptions, this.tradeCache){

            @Override
            void onSubscribe(Trade element) {
                if (tradeListener != null) {
                    tradeListener.onTrade(element);
                }
            }
        };
    }

    Registration registerQuotesListener(final QuotesListener quotesListener) {
        this.quotesListener = quotesListener;
        return new CachedRegistration<Quotes>(this.quotesSubscriptions, this.quotesCache){

            @Override
            void onSubscribe(Quotes element) {
                if (quotesListener != null) {
                    quotesListener.onQuotes(element);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerAndSubscribeSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
        Object object = this.sessionStateMonitor;
        synchronized (object) {
            SessionState sessionStateCached = this.sessionStateCached;
            if (sessionStateListener != null && sessionStateCached != null) {
                sessionStateListener.onSessionState(sessionStateCached);
            }
        }
    }

    @Override
    protected void processData(String data) throws IOException, PGPExceptionBase {
        LOGGER.trace("processData({})", (Object)data);
        String verified = this.bcSignatureVerifier.verifySignature(data);
        JsonNode dataJson = OBJECT_MAPPER.readTree(verified);
        switch (dataJson.get("type").asText()) {
            case "order_book": {
                this.onOrderBook((OrderBook)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, OrderBook.class));
                break;
            }
            case "quotes": {
                this.onQuotes((Quotes)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, Quotes.class));
                break;
            }
            case "trade": {
                this.onTrade((Trade)OBJECT_MAPPER.treeToValue((TreeNode)dataJson, Trade.class));
                break;
            }
            case "session_state": {
                this.onSessionState(SessionState.valueOf(dataJson.get("state").textValue().toUpperCase()));
                break;
            }
            case "instrument_data": {
                this.onInstrumentData((Map)OBJECT_MAPPER.treeToValue((TreeNode)dataJson.get("data"), InstrumentsMap.class));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInstrumentData(Map<Integer, Instrument> instruments) {
        Object object = this.instrumentsMonitor;
        synchronized (object) {
            this.instrumentsCached = instruments;
            InstrumentsListener instrumentsListener = this.instrumentsListener;
            if (instrumentsListener != null) {
                instrumentsListener.onInstruments(instruments);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onOrderBook(OrderBook orderBook) {
        Map<Integer, OrderBook> map = this.orderBookCache;
        synchronized (map) {
            this.orderBookCache.put(orderBook.getInstrumentId(), orderBook);
            OrderBookListener orderBookListener = this.orderBookListener;
            if (orderBookListener != null && this.orderBookSubscriptions.contains(orderBook.getInstrumentId())) {
                orderBookListener.onOrderBook(orderBook);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onQuotes(Quotes quotes) {
        Map<Integer, Quotes> map = this.quotesCache;
        synchronized (map) {
            this.quotesCache.put(quotes.getInstrumentId(), quotes);
            QuotesListener quotesListener = this.quotesListener;
            if (quotesListener != null && this.quotesSubscriptions.contains(quotes.getInstrumentId())) {
                quotesListener.onQuotes(quotes);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTrade(Trade trade) {
        Map<Integer, Trade> map = this.tradeCache;
        synchronized (map) {
            this.tradeCache.put(trade.getInstrumentId(), trade);
            TradeListener tradeListener = this.tradeListener;
            if (tradeListener != null && this.tradeSubscriptions.contains(trade.getInstrumentId())) {
                tradeListener.onTrade(trade);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSessionState(SessionState sessionState) {
        Object object = this.sessionStateMonitor;
        synchronized (object) {
            this.sessionStateCached = sessionState;
            SessionStateListener sessionStateListener = this.sessionStateListener;
            if (sessionStateListener != null) {
                sessionStateListener.onSessionState(sessionState);
            }
        }
    }

    public static class InstrumentsMap
    extends HashMap<Integer, Instrument> {
    }

    private static abstract class CachedRegistration<T>
    implements Registration {
        final Set<Integer> subscriptions;
        final Map<Integer, T> cache;

        CachedRegistration(Set<Integer> subscriptions, Map<Integer, T> cache) {
            this.subscriptions = (Set)Preconditions.checkNotNull(subscriptions, (Object)"null subscriptions");
            this.cache = (Map)Preconditions.checkNotNull(cache, (Object)"null cache");
        }

        abstract void onSubscribe(T var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CachedRegistration subscribe(int instrumentId) {
            Map<Integer, T> map = this.cache;
            synchronized (map) {
                this.subscriptions.add(instrumentId);
                T element = this.cache.get(instrumentId);
                if (element != null) {
                    this.onSubscribe(element);
                }
            }
            return this;
        }

        @Override
        public CachedRegistration subscribe(Collection<Integer> instrumentIds) {
            instrumentIds.forEach(this::subscribe);
            return this;
        }

        @Override
        public CachedRegistration unsubscribe(int instrumentId) {
            this.subscriptions.remove(instrumentId);
            return this;
        }

        @Override
        public CachedRegistration unsubscribe(Collection<Integer> instrumentIds) {
            instrumentIds.forEach(this::unsubscribe);
            return this;
        }

        @Override
        public Registration unsubscribeAll() {
            this.subscriptions.clear();
            return this;
        }
    }
}

