/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class InternalTransferExecuted {
    private final long destinationUserId;
    private final BigDecimal amount;

    @JsonCreator
    public InternalTransferExecuted(@JsonProperty(value="destination_account_id") long destinationUserId, @JsonProperty(value="amount") BigDecimal amount) {
        Preconditions.checkArgument((destinationUserId > 0L ? 1 : 0) != 0, (String)"destinationUserId=%s <= 0", (Object[])new Object[]{destinationUserId});
        Preconditions.checkArgument((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"amount=%s <= 0", (Object[])new Object[]{amount});
        this.destinationUserId = destinationUserId;
        this.amount = amount;
    }

    public long getDestinationUserId() {
        return this.destinationUserId;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransferExecuted that = (InternalTransferExecuted)o;
        return this.destinationUserId == that.destinationUserId && Objects.equal((Object)this.amount, (Object)that.amount);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.destinationUserId, this.amount});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("destinationUserId", this.destinationUserId).add("amount", (Object)this.amount).toString();
    }
}

