/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;

public class InternalTransferRejected {
    private final long destinationUserId;
    private final BigDecimal amount;
    private final Cause cause;

    @JsonCreator
    public InternalTransferRejected(@JsonProperty(value="destination_account_id") long destinationUserId, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="cause") Cause cause) {
        Preconditions.checkArgument((destinationUserId > 0L ? 1 : 0) != 0, (String)"destinationUserId=%s <= 0", (Object[])new Object[]{destinationUserId});
        Preconditions.checkArgument((amount.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"amount=%s <= 0", (Object[])new Object[]{amount});
        this.destinationUserId = destinationUserId;
        this.amount = amount;
        this.cause = (Cause)((Object)Preconditions.checkNotNull((Object)((Object)cause), (Object)"cause"));
    }

    public long getDestinationUserId() {
        return this.destinationUserId;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Cause getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransferRejected that = (InternalTransferRejected)o;
        return this.destinationUserId == that.destinationUserId && Objects.equal((Object)this.amount, (Object)that.amount) && this.cause == that.cause;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.destinationUserId, this.amount, this.cause});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("destinationUserId", this.destinationUserId).add("amount", (Object)this.amount).add("cause", (Object)this.cause).toString();
    }

    public static enum Cause {
        INSUFFICIENT_FUNDS,
        FORBIDDEN;


        @JsonCreator
        private static Cause deserialize(String value) {
            return Cause.valueOf(value.toUpperCase());
        }
    }
}

