/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import net.quedex.api.user.OrderSide;
import net.quedex.api.user.OrderSpec;
import net.quedex.api.user.OrderType;

public class LimitOrderSpec
implements OrderSpec {
    private final long clientOrderId;
    private final int instrumentId;
    private final OrderSide side;
    private final int quantity;
    private final BigDecimal limitPrice;

    public LimitOrderSpec(long clientOrderId, int instrumentId, OrderSide side, int quantity, BigDecimal limitPrice) {
        Preconditions.checkArgument((quantity > 0 ? 1 : 0) != 0, (String)"quantity=%s <= 0", (Object[])new Object[]{quantity});
        Preconditions.checkArgument((limitPrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"limitPrice=%s <= 0", (Object[])new Object[]{limitPrice});
        this.clientOrderId = clientOrderId;
        this.instrumentId = instrumentId;
        this.side = (OrderSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"null side"));
        this.quantity = quantity;
        this.limitPrice = limitPrice;
    }

    @Override
    @JsonProperty(value="client_order_id")
    public long getClientOrderId() {
        return this.clientOrderId;
    }

    @JsonProperty(value="instrument_id")
    public int getInstrumentId() {
        return this.instrumentId;
    }

    @JsonProperty(value="side")
    public OrderSide getSide() {
        return this.side;
    }

    @JsonProperty(value="quantity")
    public int getQuantity() {
        return this.quantity;
    }

    @JsonProperty(value="limit_price")
    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    @JsonProperty(value="order_type")
    public OrderType getOrderType() {
        return OrderType.LIMIT;
    }

    @JsonProperty(value="type")
    private String getType() {
        return "place_order";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitOrderSpec that = (LimitOrderSpec)o;
        return this.clientOrderId == that.clientOrderId && this.instrumentId == that.instrumentId && this.quantity == that.quantity && this.side == that.side && Objects.equal((Object)this.limitPrice, (Object)that.limitPrice);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.instrumentId, this.side, this.quantity, this.limitPrice});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("instrumentId", this.instrumentId).add("side", (Object)this.side).add("quantity", this.quantity).add("limitPrice", (Object)this.limitPrice).toString();
    }
}

