/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import net.quedex.api.user.OrderSide;
import net.quedex.api.user.OrderType;

public class OrderFilled {
    private final long clientOrderId;
    private final int instrumentId;
    private final BigDecimal orderLimitPrice;
    private final OrderType orderType;
    private final OrderSide side;
    private final int orderInitialQuantity;
    private final int leavesOrderQuantity;
    private final BigDecimal tradePrice;
    private final int filledQuantity;

    @JsonCreator
    public OrderFilled(@JsonProperty(value="client_order_id") long clientOrderId, @JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="order_limit_price") BigDecimal orderLimitPrice, @JsonProperty(value="order_side") OrderSide side, @JsonProperty(value="order_initial_quantity") int orderInitialQuantity, @JsonProperty(value="leaves_order_quantity") int leavesOrderQuantity, @JsonProperty(value="trade_price") BigDecimal tradePrice, @JsonProperty(value="trade_quantity") int filledQuantity) {
        Preconditions.checkArgument((filledQuantity > 0 ? 1 : 0) != 0, (String)"filledQuantity=%s <= 0", (Object[])new Object[]{filledQuantity});
        Preconditions.checkArgument((tradePrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"tradePrice=%s <= 0", (Object[])new Object[]{tradePrice});
        Preconditions.checkArgument((instrumentId > 0 ? 1 : 0) != 0, (String)"instrumentId=%s <= 0", (Object[])new Object[]{instrumentId});
        Preconditions.checkArgument((orderLimitPrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"orderLimitPrice=%s <= 0", (Object[])new Object[]{orderLimitPrice});
        Preconditions.checkArgument((orderInitialQuantity > 0 ? 1 : 0) != 0, (Object)"orderInitialQuantity=%s ");
        this.clientOrderId = clientOrderId;
        this.instrumentId = instrumentId;
        this.orderLimitPrice = orderLimitPrice;
        this.orderType = OrderType.LIMIT;
        this.side = (OrderSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"side"));
        this.orderInitialQuantity = orderInitialQuantity;
        this.leavesOrderQuantity = leavesOrderQuantity;
        this.filledQuantity = filledQuantity;
        this.tradePrice = tradePrice;
    }

    public long getClientOrderId() {
        return this.clientOrderId;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public BigDecimal getOrderLimitPrice() {
        return this.orderLimitPrice;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public int getOrderInitialQuantity() {
        return this.orderInitialQuantity;
    }

    public int getLeavesOrderQuantity() {
        return this.leavesOrderQuantity;
    }

    public BigDecimal getTradePrice() {
        return this.tradePrice;
    }

    public int getFilledQuantity() {
        return this.filledQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderFilled that = (OrderFilled)o;
        return this.clientOrderId == that.clientOrderId && this.instrumentId == that.instrumentId && this.orderInitialQuantity == that.orderInitialQuantity && this.leavesOrderQuantity == that.leavesOrderQuantity && this.filledQuantity == that.filledQuantity && Objects.equal((Object)this.orderLimitPrice, (Object)that.orderLimitPrice) && this.orderType == that.orderType && this.side == that.side && Objects.equal((Object)this.tradePrice, (Object)that.tradePrice);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.instrumentId, this.orderLimitPrice, this.orderType, this.side, this.orderInitialQuantity, this.leavesOrderQuantity, this.tradePrice, this.filledQuantity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("instrumentId", this.instrumentId).add("orderLimitPrice", (Object)this.orderLimitPrice).add("orderType", (Object)this.orderType).add("side", (Object)this.side).add("orderInitialQuantity", this.orderInitialQuantity).add("leavesOrderQuantity", this.leavesOrderQuantity).add("tradePrice", (Object)this.tradePrice).add("filledQuantity", this.filledQuantity).toString();
    }
}

