/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import net.quedex.api.user.OrderSide;
import net.quedex.api.user.OrderType;

public class LiquidationOrderPlaced {
    private final long systemOrderId;
    private final int instrumentId;
    @JsonIgnore
    private final OrderType type;
    private final OrderSide side;
    private final int quantity;
    private final int initialQuantity;

    @JsonCreator
    public LiquidationOrderPlaced(@JsonProperty(value="system_order_id") long systemOrderId, @JsonProperty(value="instrument_id") int instrumentId, @JsonProperty(value="side") OrderSide side, @JsonProperty(value="quantity") int quantity, @JsonProperty(value="initial_quantity") int initialQuantity) {
        Preconditions.checkArgument((systemOrderId > 0L ? 1 : 0) != 0, (String)"systemOrderId=%s <= 0", (Object[])new Object[]{systemOrderId});
        Preconditions.checkArgument((instrumentId > 0 ? 1 : 0) != 0, (String)"instrumentId=%s <= 0", (Object[])new Object[]{instrumentId});
        Preconditions.checkArgument((quantity > 0 ? 1 : 0) != 0, (String)"quantity=%s <= 0", (Object[])new Object[]{quantity});
        Preconditions.checkArgument((initialQuantity > 0 ? 1 : 0) != 0, (String)"initialQuantity=%s <= 0", (Object[])new Object[]{initialQuantity});
        this.systemOrderId = systemOrderId;
        this.instrumentId = instrumentId;
        this.type = OrderType.MARKET;
        this.side = (OrderSide)((Object)Preconditions.checkNotNull((Object)((Object)side), (Object)"null side"));
        this.quantity = quantity;
        this.initialQuantity = initialQuantity;
    }

    public long getSystemOrderId() {
        return this.systemOrderId;
    }

    public int getInstrumentId() {
        return this.instrumentId;
    }

    public OrderType getType() {
        return this.type;
    }

    public OrderSide getSide() {
        return this.side;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getInitialQuantity() {
        return this.initialQuantity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiquidationOrderPlaced that = (LiquidationOrderPlaced)o;
        return this.systemOrderId == that.systemOrderId && this.instrumentId == that.instrumentId && this.quantity == that.quantity && this.initialQuantity == that.initialQuantity && this.type == that.type && this.side == that.side;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.systemOrderId, this.instrumentId, this.type, this.side, this.quantity, this.initialQuantity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("systemOrderId", this.systemOrderId).add("instrumentId", this.instrumentId).add("type", (Object)this.type).add("side", (Object)this.side).add("quantity", this.quantity).add("initialQuantity", this.initialQuantity).toString();
    }
}

