/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class OrderModificationFailed {
    private final long clientOrderId;
    private final Cause cause;

    public OrderModificationFailed(@JsonProperty(value="client_order_id") long clientOrderId, @JsonProperty(value="cause") Cause cause) {
        this.clientOrderId = clientOrderId;
        this.cause = (Cause)((Object)Preconditions.checkNotNull((Object)((Object)cause), (Object)"null cause"));
    }

    public long getClientOrderId() {
        return this.clientOrderId;
    }

    public Cause getCause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderModificationFailed that = (OrderModificationFailed)o;
        return this.clientOrderId == that.clientOrderId && this.cause == that.cause;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.cause});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("cause", (Object)this.cause).toString();
    }

    public static enum Cause {
        INVALID_ORDER_ID,
        INVALID_INSTRUMENT_ID,
        NONPOSITIVE_QUANTITY,
        NONPOSITIVE_PRICE,
        SESSION_NOT_ACTIVE,
        INVALID_TICK_SIZE,
        INSUFFICIENT_FUNDS,
        MARGIN_CALL,
        NOT_FOUND,
        OPEN_POSITION_QUANTITY_TOO_HIGH,
        NOT_POST;


        @JsonCreator
        private static Cause deserialize(String value) {
            return Cause.valueOf(value.toUpperCase());
        }
    }
}

