/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import net.quedex.api.user.OrderSpec;

public class OrderModificationSpec
implements OrderSpec {
    private final long clientOrderId;
    private final Integer newQuantity;
    private final BigDecimal newLimitPrice;
    private final boolean postOnly;

    public OrderModificationSpec(long clientOrderId, int newQuantity, BigDecimal newLimitPrice, boolean postOnly) {
        this(clientOrderId, newQuantity, newLimitPrice, postOnly, null);
    }

    public OrderModificationSpec(long clientOrderId, int newQuantity, BigDecimal newLimitPrice) {
        this(clientOrderId, newQuantity, newLimitPrice, false, null);
    }

    public OrderModificationSpec(long clientOrderId, int newQuantity) {
        this(clientOrderId, newQuantity, null, false, null);
    }

    public OrderModificationSpec(long clientOrderId, BigDecimal newLimitPrice, boolean postOnly) {
        this(clientOrderId, null, newLimitPrice, postOnly, null);
    }

    public OrderModificationSpec(long clientOrderId, BigDecimal newLimitPrice) {
        this(clientOrderId, null, newLimitPrice, false, null);
    }

    private OrderModificationSpec(long clientOrderId, Integer newQuantity, BigDecimal newLimitPrice, boolean postOnly, Void dummy) {
        Preconditions.checkArgument((clientOrderId > 0L ? 1 : 0) != 0, (String)"clientOrderId=%s <= 0", (Object[])new Object[]{clientOrderId});
        Preconditions.checkArgument((newQuantity != null || newLimitPrice != null ? 1 : 0) != 0, (Object)"at least one of newQuantity and newLimitPrice must be specified");
        Preconditions.checkArgument((newQuantity == null || newQuantity > 0 ? 1 : 0) != 0, (String)"newQuantity=%s <= 0", (Object[])new Object[]{newQuantity});
        Preconditions.checkArgument((newLimitPrice == null || newLimitPrice.compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"newLImitPrice=%s <= 0", (Object[])new Object[]{newLimitPrice});
        this.clientOrderId = clientOrderId;
        this.newQuantity = newQuantity;
        this.newLimitPrice = newLimitPrice;
        this.postOnly = postOnly;
    }

    @JsonProperty(value="client_order_id")
    public long getClientOrderId() {
        return this.clientOrderId;
    }

    @JsonProperty(value="new_quantity")
    public Integer getNewQuantity() {
        return this.newQuantity;
    }

    @JsonProperty(value="new_limit_price")
    public BigDecimal getNewLimitPrice() {
        return this.newLimitPrice;
    }

    @JsonProperty(value="post_only")
    public Boolean getPostOnly() {
        return this.postOnly;
    }

    @JsonProperty(value="type")
    private String getType() {
        return "modify_order";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderModificationSpec that = (OrderModificationSpec)o;
        return this.clientOrderId == that.clientOrderId && Objects.equal((Object)this.newQuantity, (Object)that.newQuantity) && Objects.equal((Object)this.newLimitPrice, (Object)that.newLimitPrice) && Objects.equal((Object)this.postOnly, (Object)that.postOnly);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.clientOrderId, this.newQuantity, this.newLimitPrice, this.postOnly});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientOrderId", this.clientOrderId).add("newQuantity", (Object)this.newQuantity).add("newLimitPrice", (Object)this.newLimitPrice).add("postOnly", this.postOnly).toString();
    }
}

