/*
 * Decompiled with CFR 0.152.
 */
package net.quedex.api.user;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.quedex.api.common.CommunicationException;
import net.quedex.api.common.Config;
import net.quedex.api.common.StreamFailureListener;
import net.quedex.api.common.WebsocketStream;
import net.quedex.api.pgp.BcEncryptor;
import net.quedex.api.pgp.BcPrivateKey;
import net.quedex.api.pgp.BcPublicKey;
import net.quedex.api.user.AccountStateListener;
import net.quedex.api.user.CancelAllOrdersSpec;
import net.quedex.api.user.InternalTransfer;
import net.quedex.api.user.InternalTransferListener;
import net.quedex.api.user.LimitOrderSpec;
import net.quedex.api.user.OpenPositionListener;
import net.quedex.api.user.OrderCancelSpec;
import net.quedex.api.user.OrderListener;
import net.quedex.api.user.OrderModificationSpec;
import net.quedex.api.user.OrderSpec;
import net.quedex.api.user.TimerListener;
import net.quedex.api.user.UserMessageReceiver;
import net.quedex.api.user.UserMessageSender;
import net.quedex.api.user.UserStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketUserStream
extends WebsocketStream<UserMessageReceiver>
implements UserStream {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsocketUserStream.class);
    private final UserMessageSender sender;

    public WebsocketUserStream(String streamUrl, long accountId, int nonceGroup, BcPublicKey qdxPublicKey, BcPrivateKey userPrivateKey) {
        super(LOGGER, streamUrl, new UserMessageReceiver(qdxPublicKey, userPrivateKey));
        this.sender = new UserMessageSender(this.webSocketClient, accountId, nonceGroup, new BcEncryptor(qdxPublicKey, userPrivateKey));
    }

    public WebsocketUserStream(Config config) {
        this(config.getUserStreamUrl(), config.getAccountId(), config.getNonceGroup(), config.getQdxPublicKey(), config.getUserPrivateKey());
    }

    @Override
    public void registerStreamFailureListener(StreamFailureListener streamFailureListener) {
        super.registerStreamFailureListener(streamFailureListener);
        this.sender.registerStreamFailureListener(streamFailureListener);
    }

    @Override
    public void start() throws CommunicationException {
        super.start();
        this.sender.sendGetLastNonce();
        try {
            this.sender.setStartNonce(((UserMessageReceiver)this.messageReceiver).getLastNonce());
        }
        catch (TimeoutException e) {
            throw new CommunicationException("Timeout waiting for last nonce", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void registerOrderListener(OrderListener orderListener) {
        ((UserMessageReceiver)this.messageReceiver).registerOrderListener(orderListener);
    }

    @Override
    public void registerOpenPositionListener(OpenPositionListener openPositionListener) {
        ((UserMessageReceiver)this.messageReceiver).registerOpenPositionListener(openPositionListener);
    }

    @Override
    public void registerAccountStateListener(AccountStateListener accountStateListener) {
        ((UserMessageReceiver)this.messageReceiver).registerAccountStateListener(accountStateListener);
    }

    @Override
    public void registerInternalTransferListener(InternalTransferListener listener) {
        ((UserMessageReceiver)this.messageReceiver).registerInternalTransferListener(listener);
    }

    @Override
    public void registerTimerListener(TimerListener listener) {
        ((UserMessageReceiver)this.messageReceiver).registerTimeTriggeredBatchListener(listener);
    }

    @Override
    public void subscribeListeners() {
        this.sender.sendSubscribe();
    }

    @Override
    public void placeOrder(LimitOrderSpec limitOrderSpec) {
        this.sender.sendOrderSpec(limitOrderSpec);
    }

    @Override
    public void cancelOrder(OrderCancelSpec orderCancelSpec) {
        this.sender.sendOrderSpec(orderCancelSpec);
    }

    @Override
    public void cancelAllOrders() {
        this.sender.sendOrderSpec(CancelAllOrdersSpec.INSTANCE);
    }

    @Override
    public void modifyOrder(OrderModificationSpec orderModificationSpec) {
        this.sender.sendOrderSpec(orderModificationSpec);
    }

    @Override
    public UserStream.Batch batch() {
        return new BatchImpl();
    }

    @Override
    public void batch(List<? extends OrderSpec> batch) {
        this.sender.sendBatch(batch);
    }

    @Override
    public UserStream.Batch timeTriggeredBatch(long timerId, long executionStartTimestamp, long executionExpirationTimestamp) {
        return new CreateTimeTriggeredBatchImpl(timerId, executionStartTimestamp, executionExpirationTimestamp);
    }

    @Override
    public void timeTriggeredBatch(long timerId, long executionStartTimestamp, long executionExpirationTimestamp, List<? extends OrderSpec> batch) {
        this.sender.sendTimeTriggeredBatch(timerId, executionStartTimestamp, executionExpirationTimestamp, batch);
    }

    @Override
    public UserStream.Batch updateTimeTriggeredBatch(long timerId, Long executionStartTimestamp, Long executionExpirationTimestamp) {
        return new UpdateTimeTriggeredBatchImpl(timerId, executionStartTimestamp, executionExpirationTimestamp);
    }

    @Override
    public void updateTimeTriggeredBatch(long timerId, Long executionStartTimestamp, Long executionExpirationTimestamp, List<? extends OrderSpec> batch) {
        this.sender.sendTimeTriggeredBatchUpdate(timerId, executionStartTimestamp, executionExpirationTimestamp, batch);
    }

    @Override
    public void cancelTimeTriggeredBatch(long timerId) {
        this.sender.sendTimeTriggeredBatchCancellation(timerId);
    }

    @Override
    public void executeInternalTransfer(InternalTransfer internalTransfer) {
        this.sender.sendInternalTransfer(internalTransfer);
    }

    @Override
    public void stop() throws CommunicationException {
        super.stop();
        this.sender.stop();
    }

    private final class UpdateTimeTriggeredBatchImpl
    extends TimeTiggeredBatch {
        public UpdateTimeTriggeredBatchImpl(long timerId, Long executionStartTimestamp, Long executionExpirationTimestamp) {
            super(timerId, executionStartTimestamp, executionExpirationTimestamp);
        }

        @Override
        protected void sendBatch(List<OrderSpec> batch) {
            WebsocketUserStream.this.updateTimeTriggeredBatch(this.getTimerId(), this.getExecutionStartTimestamp(), this.getExecutionExpirationTimestamp(), batch);
        }
    }

    private final class CreateTimeTriggeredBatchImpl
    extends TimeTiggeredBatch {
        public CreateTimeTriggeredBatchImpl(long timerId, long executionStartTimestamp, long executionExpirationTimestamp) {
            super(timerId, executionStartTimestamp, executionExpirationTimestamp);
        }

        @Override
        protected void sendBatch(List<OrderSpec> batch) {
            WebsocketUserStream.this.timeTriggeredBatch(this.getTimerId(), this.getExecutionStartTimestamp(), this.getExecutionExpirationTimestamp(), batch);
        }
    }

    private abstract class TimeTiggeredBatch
    extends AbstractBatch {
        private final long timerId;
        private final Long executionStartTimestamp;
        private final Long executionExpirationTimestamp;

        public TimeTiggeredBatch(long timerId, Long executionStartTimestamp, Long executionExpirationTimestamp) {
            this.timerId = timerId;
            this.executionStartTimestamp = executionStartTimestamp;
            this.executionExpirationTimestamp = executionExpirationTimestamp;
        }

        public long getTimerId() {
            return this.timerId;
        }

        public Long getExecutionStartTimestamp() {
            return this.executionStartTimestamp;
        }

        public Long getExecutionExpirationTimestamp() {
            return this.executionExpirationTimestamp;
        }
    }

    private final class BatchImpl
    extends AbstractBatch {
        private BatchImpl() {
        }

        @Override
        protected void sendBatch(List<OrderSpec> batch) {
            WebsocketUserStream.this.batch(batch);
        }
    }

    private abstract class AbstractBatch
    implements UserStream.Batch {
        private final List<OrderSpec> batch = new ArrayList<OrderSpec>();
        private boolean sent;

        private AbstractBatch() {
        }

        @Override
        public UserStream.Batch placeOrder(LimitOrderSpec limitOrderSpec) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.add(limitOrderSpec);
            return this;
        }

        @Override
        public UserStream.Batch placeOrders(List<LimitOrderSpec> limitOrderSpecs) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.addAll(limitOrderSpecs);
            return this;
        }

        @Override
        public UserStream.Batch cancelOrder(OrderCancelSpec orderCancelSpec) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.add(orderCancelSpec);
            return this;
        }

        @Override
        public UserStream.Batch cancelOrders(List<OrderCancelSpec> orderCancelSpecs) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.addAll(orderCancelSpecs);
            return this;
        }

        @Override
        public UserStream.Batch cancelAllOrders() {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            Preconditions.checkState((boolean)this.batch.isEmpty(), (Object)"Cancel all makes sense only as first command in batch");
            this.batch.add(CancelAllOrdersSpec.INSTANCE);
            return this;
        }

        @Override
        public UserStream.Batch modifyOrder(OrderModificationSpec orderModificationSpec) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.add(orderModificationSpec);
            return this;
        }

        @Override
        public UserStream.Batch modifyOrders(List<OrderModificationSpec> orderModificationSpec) {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.batch.addAll(orderModificationSpec);
            return this;
        }

        @Override
        public void send() {
            Preconditions.checkState((!this.sent ? 1 : 0) != 0, (Object)"Batch already sent");
            this.sent = true;
            this.sendBatch(this.batch);
        }

        protected abstract void sendBatch(List<OrderSpec> var1);
    }
}

