/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib;

import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.raphimc.noteblocklib.format.SongFormat;
import net.raphimc.noteblocklib.format.future.FutureParser;
import net.raphimc.noteblocklib.format.midi.MidiParser;
import net.raphimc.noteblocklib.format.nbs.NbsParser;
import net.raphimc.noteblocklib.format.nbs.NbsSong;
import net.raphimc.noteblocklib.format.nbs.model.NbsData;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;
import net.raphimc.noteblocklib.format.txt.TxtParser;
import net.raphimc.noteblocklib.format.txt.TxtSong;
import net.raphimc.noteblocklib.model.Song;
import net.raphimc.noteblocklib.model.SongView;

public class NoteBlockLib {
    public static Song<?, ?, ?> readSong(File file) throws Exception {
        return NoteBlockLib.readSong(file.toPath());
    }

    public static Song<?, ?, ?> readSong(Path path) throws Exception {
        return NoteBlockLib.readSong(path, NoteBlockLib.getFormat(path));
    }

    public static Song<?, ?, ?> readSong(Path path, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(Files.readAllBytes(path), format, path.getFileName().toString());
    }

    public static Song<?, ?, ?> readSong(InputStream is, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(ByteStreams.toByteArray((InputStream)is), format, null);
    }

    public static Song<?, ?, ?> readSong(byte[] bytes, SongFormat format) throws Exception {
        return NoteBlockLib.readSong(bytes, format, null);
    }

    public static Song<?, ?, ?> readSong(byte[] bytes, SongFormat format, String fileName) throws Exception {
        try {
            if (format == null) {
                throw new IllegalArgumentException("Unknown format");
            }
            switch (format) {
                case NBS: {
                    return NbsParser.read(bytes, fileName);
                }
                case TXT: {
                    return TxtParser.read(bytes, fileName);
                }
                case FUTURE: {
                    return FutureParser.read(bytes, fileName);
                }
                case MIDI: {
                    return MidiParser.read(bytes, fileName);
                }
            }
            throw new IllegalStateException("Unknown format");
        }
        catch (Throwable e) {
            throw new Exception("Failed to read song", e);
        }
    }

    public static void writeSong(Song<?, ?, ?> song, File file) throws Exception {
        NoteBlockLib.writeSong(song, file.toPath());
    }

    public static void writeSong(Song<?, ?, ?> song, Path path) throws Exception {
        Files.write(path, NoteBlockLib.writeSong(song), new OpenOption[0]);
    }

    public static void writeSong(Song<?, ?, ?> song, OutputStream os) throws Exception {
        os.write(NoteBlockLib.writeSong(song));
    }

    public static byte[] writeSong(Song<?, ?, ?> song) throws Exception {
        byte[] bytes = null;
        try {
            if (song instanceof NbsSong) {
                bytes = NbsParser.write((NbsSong)song);
            } else if (song instanceof TxtSong) {
                bytes = TxtParser.write((TxtSong)song);
            }
        }
        catch (Throwable e) {
            throw new Exception("Failed to write song", e);
        }
        if (bytes == null) {
            throw new Exception("Unsupported song type for writing: " + song.getClass().getSimpleName());
        }
        return bytes;
    }

    public static Song<?, ?, ?> createSongFromView(SongView<?> songView, SongFormat format) {
        if (format != SongFormat.NBS) {
            throw new IllegalArgumentException("Only NBS is supported for creating songs from views");
        }
        return new NbsSong(null, new NbsHeader(songView), new NbsData(songView));
    }

    public static SongFormat getFormat(Path path) {
        return SongFormat.getByExtension(com.google.common.io.Files.getFileExtension((String)path.getFileName().toString()));
    }
}

