/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.format.nbs;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.raphimc.noteblocklib.format.nbs.NbsSong;
import net.raphimc.noteblocklib.format.nbs.model.NbsData;
import net.raphimc.noteblocklib.format.nbs.model.NbsHeader;

public class NbsParser {
    public static NbsSong read(byte[] bytes, String fileName) throws IOException {
        LittleEndianDataInputStream dis = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(bytes));
        NbsHeader header = new NbsHeader(dis);
        NbsData data = new NbsData(header, dis);
        return new NbsSong(fileName, header, data);
    }

    public static byte[] write(NbsSong song) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        LittleEndianDataOutputStream dos = new LittleEndianDataOutputStream((OutputStream)bytes);
        ((NbsHeader)song.getHeader()).write(dos);
        ((NbsData)song.getData()).write((NbsHeader)song.getHeader(), dos);
        return bytes.toByteArray();
    }

    public static String readString(LittleEndianDataInputStream dis) throws IOException {
        int length;
        StringBuilder builder = new StringBuilder(length);
        for (length = dis.readInt(); length > 0; --length) {
            builder.append((char)dis.readByte());
        }
        return builder.toString();
    }

    public static void writeString(LittleEndianDataOutputStream dos, String string) throws IOException {
        dos.writeInt(string.length());
        for (char c : string.toCharArray()) {
            dos.writeByte((int)c);
        }
    }
}

