/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.noteblocklib.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.raphimc.noteblocklib.model.Note;

public class SongView<N extends Note> {
    private String title;
    private int length;
    private float speed;
    private Map<Integer, List<N>> notes;

    public SongView(String title, float speed, Map<Integer, List<N>> notes) {
        this.title = title;
        this.speed = speed;
        this.notes = notes;
        this.recalculateLength();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getLength() {
        return this.length;
    }

    public void recalculateLength() {
        this.length = this.notes.keySet().stream().mapToInt(i -> i).max().orElse(0);
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public List<N> getNotesAtTick(int tick) {
        return this.notes.getOrDefault(tick, Collections.emptyList());
    }

    public void setNotesAtTick(int tick, List<N> notes) {
        this.notes.put(tick, notes);
    }

    public Map<Integer, List<N>> getNotes() {
        return this.notes;
    }

    public void setNotes(Map<Integer, List<N>> notes) {
        this.notes = notes;
    }
}

