/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.io.IOException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.asterisk.fastagi.AGIConnectionHandler;
import net.sf.asterisk.fastagi.AGIServer;
import net.sf.asterisk.fastagi.MappingStrategy;
import net.sf.asterisk.fastagi.ResourceBundleMappingStrategy;
import net.sf.asterisk.io.ServerSocketFacade;
import net.sf.asterisk.io.ServerSocketFacadeImpl;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.util.ThreadPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultAGIServer
implements AGIServer {
    private static final String DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME = "fastagi";
    private static final int DEFAULT_BIND_PORT = 4573;
    private static final int DEFAULT_POOL_SIZE = 10;
    private final Log logger = LogFactory.getLog((Class)(class$net$sf$asterisk$fastagi$DefaultAGIServer == null ? (class$net$sf$asterisk$fastagi$DefaultAGIServer = DefaultAGIServer.class$("net.sf.asterisk.fastagi.DefaultAGIServer")) : class$net$sf$asterisk$fastagi$DefaultAGIServer));
    private ServerSocketFacade serverSocket;
    private int bindPort = 4573;
    private ThreadPool pool;
    private int poolSize = 10;
    private boolean die;
    private MappingStrategy mappingStrategy = new ResourceBundleMappingStrategy();
    static /* synthetic */ Class class$net$sf$asterisk$fastagi$DefaultAGIServer;

    public DefaultAGIServer() {
        this.loadConfig();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void setBindPort(int bindPort) {
        this.bindPort = bindPort;
    }

    public void setMappingStrategy(MappingStrategy mappingStrategy) {
        this.mappingStrategy = mappingStrategy;
    }

    private void loadConfig() {
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle(DEFAULT_CONFIG_RESOURCE_BUNDLE_NAME);
        }
        catch (MissingResourceException e) {
            return;
        }
        try {
            String bindPortString = resourceBundle.getString("bindPort");
            this.bindPort = Integer.parseInt(bindPortString);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String poolSizeString = resourceBundle.getString("poolSize");
            this.poolSize = Integer.parseInt(poolSizeString);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ServerSocketFacade createServerSocket() throws IOException {
        return new ServerSocketFacadeImpl(this.bindPort, 0, null);
    }

    public void startup() throws IOException, IllegalStateException {
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block13: {
            block12: {
                SocketConnectionFacade socket;
                this.die = false;
                this.pool = new ThreadPool("AGIServer", this.poolSize);
                this.logger.info((Object)"Thread pool started.");
                this.serverSocket = this.createServerSocket();
                this.logger.info((Object)("Listening on *:" + this.bindPort + "."));
                while ((socket = this.serverSocket.accept()) != null) {
                    this.logger.info((Object)"Received connection.");
                    AGIConnectionHandler connectionHandler = new AGIConnectionHandler(socket, this.mappingStrategy);
                    this.pool.addJob(connectionHandler);
                }
                Object var5_3 = null;
                if (this.serverSocket == null) break block12;
                try {
                    this.serverSocket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            this.serverSocket = null;
            this.pool.shutdown();
            this.logger.info((Object)"AGIServer shut down.");
            {
                break block13;
                catch (IOException e) {
                    if (!this.die) {
                        this.logger.error((Object)"IOException while waiting for connections.", (Throwable)e);
                    }
                    Object var5_4 = null;
                    if (this.serverSocket != null) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    this.serverSocket = null;
                    this.pool.shutdown();
                    this.logger.info((Object)"AGIServer shut down.");
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                this.serverSocket = null;
                this.pool.shutdown();
                this.logger.info((Object)"AGIServer shut down.");
                throw throwable;
            }
        }
    }

    public void die() throws IOException {
        this.die = true;
        if (this.serverSocket != null) {
            this.serverSocket.close();
        }
    }

    public void shutdown() throws IOException, IllegalStateException {
        this.die();
    }

    public static void main(String[] args) throws Exception {
        DefaultAGIServer server = new DefaultAGIServer();
        server.startup();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

