/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.fastagi;

import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.asterisk.fastagi.AGIRequest;
import net.sf.asterisk.fastagi.AGIScript;
import net.sf.asterisk.fastagi.MappingStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceBundleMappingStrategy
implements MappingStrategy {
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "fastagi-mapping";
    private final Log logger = LogFactory.getLog(this.getClass());
    private String resourceBundleName = "fastagi-mapping";
    private Map mapping = null;

    public void setResourceBundleName(String propertiesName) {
        this.resourceBundleName = propertiesName;
    }

    private void loadResourceBundle() {
        ResourceBundle resourceBundle;
        this.mapping = new HashMap();
        try {
            resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
        }
        catch (MissingResourceException e) {
            this.logger.error((Object)("Resource bundle " + this.resourceBundleName + " is missing."));
            return;
        }
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String scriptName = keys.nextElement();
            String className = resourceBundle.getString(scriptName);
            AGIScript agiScript = this.createAGIScriptInstance(className);
            if (agiScript == null) continue;
            this.mapping.put(scriptName, agiScript);
        }
    }

    private AGIScript createAGIScriptInstance(String className) {
        AGIScript agiScript;
        try {
            Class<?> agiScriptClass = Class.forName(className);
            Constructor<?> constructor = agiScriptClass.getConstructor(new Class[0]);
            agiScript = (AGIScript)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to create AGIScript instance of type " + className));
            return null;
        }
        return agiScript;
    }

    public AGIScript determineScript(AGIRequest request) {
        if (this.mapping == null) {
            this.loadResourceBundle();
        }
        return (AGIScript)this.mapping.get(request.getScript());
    }
}

