/*
 * Decompiled with CFR 0.152.
 */
package net.sf.asterisk.manager;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.sf.asterisk.io.SocketConnectionFacade;
import net.sf.asterisk.io.SocketConnectionFacadeImpl;
import net.sf.asterisk.manager.AsteriskServer;
import net.sf.asterisk.manager.AuthenticationFailedException;
import net.sf.asterisk.manager.Dispatcher;
import net.sf.asterisk.manager.ManagerConnection;
import net.sf.asterisk.manager.ManagerEventHandler;
import net.sf.asterisk.manager.ManagerReader;
import net.sf.asterisk.manager.ManagerResponseHandler;
import net.sf.asterisk.manager.ManagerWriter;
import net.sf.asterisk.manager.TimeoutException;
import net.sf.asterisk.manager.Util;
import net.sf.asterisk.manager.action.ChallengeAction;
import net.sf.asterisk.manager.action.LoginAction;
import net.sf.asterisk.manager.action.LogoffAction;
import net.sf.asterisk.manager.action.ManagerAction;
import net.sf.asterisk.manager.event.ConnectEvent;
import net.sf.asterisk.manager.event.DisconnectEvent;
import net.sf.asterisk.manager.event.ManagerEvent;
import net.sf.asterisk.manager.impl.ManagerReaderImpl;
import net.sf.asterisk.manager.impl.ManagerWriterImpl;
import net.sf.asterisk.manager.response.ChallengeResponse;
import net.sf.asterisk.manager.response.ManagerError;
import net.sf.asterisk.manager.response.ManagerResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultManagerConnection
implements ManagerConnection,
Dispatcher {
    private final Log logger = LogFactory.getLog(this.getClass());
    private long actionIdCount = 0L;
    private AsteriskServer asteriskServer = new AsteriskServer();
    protected String username;
    protected String password;
    private long defaultTimeout = 2000L;
    private long sleepTime = 50L;
    private boolean keepAliveAfterAuthenticationFailure = false;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private ManagerReader reader;
    private ManagerWriter writer;
    private String protocolIdentifier;
    private final Map responseHandlers = new HashMap();
    private final Collection eventHandlers = new HashSet();
    protected boolean keepAlive = false;

    public DefaultManagerConnection() {
    }

    public DefaultManagerConnection(String hostname, int port, String username, String password) {
        this();
        this.setHostname(hostname);
        this.setPort(port);
        this.setUsername(username);
        this.setPassword(password);
    }

    protected ManagerReader createReader(Dispatcher dispatcher, AsteriskServer server) {
        return new ManagerReaderImpl(dispatcher, server);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String hostname) {
        this.asteriskServer.setHostname(hostname);
    }

    public void setPort(int port) {
        this.asteriskServer.setPort(port);
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean keepAliveAfterAuthenticationFailure) {
        this.keepAliveAfterAuthenticationFailure = keepAliveAfterAuthenticationFailure;
    }

    public void registerUserEventClass(Class userEventClass) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this.asteriskServer);
        }
        this.reader.registerEventClass(userEventClass);
    }

    public void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(this.defaultTimeout);
    }

    private void login(long timeout) throws IOException, AuthenticationFailedException, TimeoutException {
        if (!this.isConnected()) {
            this.connect();
        }
        long timeSpent = 0L;
        while (this.getProtocolIdentifier() == null) {
            try {
                Thread.sleep(this.sleepTime);
                if ((timeSpent += this.sleepTime) <= timeout) continue;
                this.disconnect();
                throw new TimeoutException("Timeout waiting for protocol identifier");
            }
            catch (InterruptedException e) {
            }
        }
        ChallengeAction challengeAction = new ChallengeAction();
        challengeAction.setAuthType("MD5");
        ChallengeResponse challengeResponse = (ChallengeResponse)this.sendAction(challengeAction);
        String challenge = challengeResponse.getChallenge();
        LoginAction loginAction = new LoginAction();
        loginAction.setAuthType("MD5");
        loginAction.setUsername(this.username);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            if (challenge != null) {
                md.update(challenge.getBytes());
            }
            if (this.password != null) {
                md.update(this.password.getBytes());
            }
            loginAction.setKey(Util.toHexString(md.digest()));
        }
        catch (NoSuchAlgorithmException ex) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", ex);
        }
        ManagerResponse loginResponse = this.sendAction(loginAction);
        if (loginResponse instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(loginResponse.getMessage());
        }
        this.keepAlive = true;
        this.logger.info((Object)"Successfully logged in");
    }

    protected synchronized void connect() throws IOException {
        this.logger.info((Object)("Connecting to " + this.asteriskServer.getHostname() + " port " + this.asteriskServer.getPort()));
        if (this.reader == null) {
            this.reader = this.createReader(this, this.asteriskServer);
        }
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        this.socket = this.createSocket();
        this.reader.setSocket(this.socket);
        this.readerThread = new Thread((Runnable)this.reader, "ManagerReaderThread");
        this.readerThread.start();
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.asteriskServer.getHostname(), this.asteriskServer.getPort());
    }

    private synchronized boolean isConnected() {
        return this.socket != null;
    }

    public synchronized void logoff() throws IOException, TimeoutException {
        this.keepAlive = false;
        LogoffAction logoffAction = new LogoffAction();
        if (this.isConnected()) {
            this.sendAction(logoffAction);
            this.disconnect();
        }
    }

    private synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info((Object)"Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                this.logger.warn((Object)("Unable to close socket: " + ex.getMessage()));
            }
            this.socket = null;
        }
    }

    public ManagerResponse sendAction(ManagerAction action) throws IOException, TimeoutException {
        return this.sendAction(action, this.defaultTimeout);
    }

    public ManagerResponse sendAction(ManagerAction action, long timeout) throws IOException, TimeoutException {
        ResponseHandlerResult result = new ResponseHandlerResult();
        DefaultResponseHandler callbackHandler = new DefaultResponseHandler(result);
        this.sendAction(action, callbackHandler);
        long timeSpent = 0L;
        while (result.getResponse() == null) {
            try {
                Thread.sleep(this.sleepTime);
                if ((timeSpent += this.sleepTime) <= timeout) continue;
                throw new TimeoutException("Timeout waiting for response to " + action.getAction());
            }
            catch (InterruptedException ex) {
            }
        }
        return result.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAction(ManagerAction action, ManagerResponseHandler callbackHandler) throws IOException {
        if (action == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!this.isConnected()) {
            throw new IllegalStateException("Unable to send " + action.getAction() + " action: not connected.");
        }
        String internalActionId = this.createInternalActionId();
        if (action.getActionId() == null) {
            action.setActionId(internalActionId + "-");
        } else {
            action.setActionId(internalActionId + "-" + action.getActionId());
        }
        if (callbackHandler != null) {
            Map map = this.responseHandlers;
            synchronized (map) {
                this.responseHandlers.put(internalActionId, callbackHandler);
            }
        }
        this.writer.sendAction(action);
    }

    private String createInternalActionId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.hashCode());
        sb.append("_");
        sb.append(this.actionIdCount++);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventHandler(ManagerEventHandler eventHandler) {
        Collection collection = this.eventHandlers;
        synchronized (collection) {
            this.eventHandlers.add(eventHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventHandler(ManagerEventHandler eventHandler) {
        Collection collection = this.eventHandlers;
        synchronized (collection) {
            if (this.eventHandlers.contains(eventHandler)) {
                this.eventHandlers.remove(eventHandler);
            }
        }
    }

    public String getProtocolIdentifier() {
        return this.protocolIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResponse(ManagerResponse response) {
        if (response == null) {
            this.logger.error((Object)"Unable to dispatch null response");
            return;
        }
        String actionId = response.getActionId();
        String internalActionId = null;
        ManagerResponseHandler responseHandler = null;
        if (actionId != null) {
            internalActionId = Util.getInternalActionId(actionId);
            response.setActionId(Util.stripInternalActionId(actionId));
        }
        this.logger.debug((Object)("Dispatching response with internalActionId '" + internalActionId + "':\n" + response));
        if (internalActionId != null) {
            Map map = this.responseHandlers;
            synchronized (map) {
                responseHandler = (ManagerResponseHandler)this.responseHandlers.get(internalActionId);
                if (responseHandler != null) {
                    this.responseHandlers.remove(internalActionId);
                } else {
                    this.logger.warn((Object)("No response handler registered for internalActionId '" + internalActionId + "'"));
                }
            }
        } else {
            this.logger.error((Object)("Unable to retrieve internalActionId from response: asterisk sent actionId '" + actionId + "':\n" + response));
        }
        if (responseHandler != null) {
            try {
                responseHandler.handleResponse(response);
            }
            catch (Exception e) {
                this.logger.warn((Object)"Exception calling responseHandler", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(ManagerEvent event) {
        if (event == null) {
            this.logger.error((Object)"Unable to dispatch null event");
            return;
        }
        this.logger.debug((Object)("Dispatching event:\n" + event));
        Collection collection = this.eventHandlers;
        synchronized (collection) {
            Iterator i = this.eventHandlers.iterator();
            while (i.hasNext()) {
                ManagerEventHandler eventHandler = (ManagerEventHandler)i.next();
                try {
                    eventHandler.handleEvent(event);
                }
                catch (Exception e) {
                    this.logger.warn((Object)"Exception calling eventHandler", (Throwable)e);
                }
            }
        }
        if (event instanceof ConnectEvent) {
            this.setProtocolIdentifier(((ConnectEvent)event).getProtocolIdentifier());
        }
        if (event instanceof DisconnectEvent) {
            this.reconnect();
        }
    }

    private void setProtocolIdentifier(String protocolIdentifier) {
        this.logger.info((Object)("Connected via " + protocolIdentifier));
        if (!"Asterisk Call Manager/1.0".equals(protocolIdentifier)) {
            this.logger.warn((Object)("Unsupported protocol version '" + protocolIdentifier + "'. This library has only been tested with version 1.0 of the asterisk " + "call manager protocol. Use at your own risk!"));
        }
        this.protocolIdentifier = protocolIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        this.disconnect();
        int numTries = 0;
        while (this.keepAlive) {
            try {
                if (numTries < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            try {
                this.connect();
                try {
                    this.login();
                    this.logger.info((Object)"Successfully reconnected.");
                    break;
                }
                catch (AuthenticationFailedException e1) {
                    if (this.keepAliveAfterAuthenticationFailure) {
                        this.logger.error((Object)"Unable to log in after reconnect.");
                    } else {
                        this.logger.error((Object)"Unable to log in after reconnect. Giving up.");
                        this.keepAlive = false;
                    }
                }
                catch (TimeoutException e1) {
                    this.logger.error((Object)"TimeoutException while trying to log in after reconnect.");
                    DefaultManagerConnection defaultManagerConnection = this;
                    synchronized (defaultManagerConnection) {
                        this.socket.close();
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)("Exception while trying to reconnect: " + e.getMessage()));
            }
            ++numTries;
        }
    }

    public AsteriskServer getAsteriskServer() {
        return this.asteriskServer;
    }

    private class DefaultResponseHandler
    implements ManagerResponseHandler,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private ResponseHandlerResult result;

        public DefaultResponseHandler(ResponseHandlerResult result) {
            this.result = result;
        }

        public void handleResponse(ManagerResponse response) {
            this.result.setResponse(response);
        }
    }

    private class ResponseHandlerResult
    implements Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;

        public ManagerResponse getResponse() {
            return this.response;
        }

        public void setResponse(ManagerResponse response) {
            this.response = response;
        }
    }
}

