/*
 * Decompiled with CFR 0.152.
 */
package net.voidnote;

import java.util.Set;

public final class CreateOptions {
    private static final Set<Integer> ALLOWED_EXPIRY_HOURS = Set.of(Integer.valueOf(1), Integer.valueOf(6), Integer.valueOf(24), Integer.valueOf(72), Integer.valueOf(168), Integer.valueOf(720));
    public final String apiKey;
    public final String title;
    public final Integer maxViews;
    public final Integer expiresIn;
    public final String noteType;

    private CreateOptions(String apiKey, String title, Integer maxViews, Integer expiresIn, String noteType) {
        this.apiKey = apiKey;
        this.title = title;
        this.maxViews = maxViews;
        this.expiresIn = expiresIn;
        this.noteType = noteType;
    }

    public static CreateOptions of(String apiKey) {
        return new CreateOptions(apiKey, null, null, null, null);
    }

    public CreateOptions withTitle(String title) {
        return new CreateOptions(this.apiKey, title, this.maxViews, this.expiresIn, this.noteType);
    }

    public CreateOptions withMaxViews(int maxViews) {
        return new CreateOptions(this.apiKey, this.title, maxViews, this.expiresIn, this.noteType);
    }

    public CreateOptions withExpiresIn(int hours) {
        if (!ALLOWED_EXPIRY_HOURS.contains(hours)) {
            throw new IllegalArgumentException("expiresIn must be one of 1, 6, 24, 72, 168, 720 \u2014 got " + hours);
        }
        return new CreateOptions(this.apiKey, this.title, this.maxViews, hours, this.noteType);
    }

    public CreateOptions withNoteType(String noteType) {
        if (!"secure".equals(noteType) && !"pipe".equals(noteType)) {
            throw new IllegalArgumentException("noteType must be \"secure\" or \"pipe\" \u2014 got \"" + noteType + "\"");
        }
        return new CreateOptions(this.apiKey, this.title, this.maxViews, this.expiresIn, noteType);
    }
}

