/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.rclass;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.androidannotations.helper.AndroidManifest;
import org.androidannotations.helper.Option;
import org.androidannotations.helper.OptionsHelper;
import org.androidannotations.logger.Logger;
import org.androidannotations.logger.LoggerFactory;
import org.androidannotations.rclass.IRClass;
import org.androidannotations.rclass.RClass;

public class ProjectRClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRClassFinder.class);
    private ProcessingEnvironment processingEnv;
    private OptionsHelper optionsHelper;

    public ProjectRClassFinder(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.optionsHelper = new OptionsHelper(processingEnv);
    }

    public Option<IRClass> find(AndroidManifest manifest) {
        String rClass;
        Elements elementUtils = this.processingEnv.getElementUtils();
        TypeElement rType = elementUtils.getTypeElement(rClass = this.getRClassPackageName(manifest) + ".R");
        if (rType == null) {
            LOGGER.error("The generated {} class cannot be found", rClass);
            return Option.absent();
        }
        LOGGER.info("Found project R class: {}", rType.toString());
        return Option.of(new RClass(rType));
    }

    public String getRClassPackageName(AndroidManifest manifest) {
        String resourcePackageName = this.optionsHelper.getResourcePackageName();
        if (resourcePackageName != null) {
            return resourcePackageName;
        }
        return manifest.getApplicationPackage();
    }
}

