/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.InstanceState;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.helper.BundleHelper;
import org.androidannotations.holder.HasInstanceState;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class InstanceStateHandler
extends BaseAnnotationHandler<HasInstanceState> {
    private final APTCodeModelHelper codeModelHelper = new APTCodeModelHelper();
    private AnnotationHelper annotationHelper = new AnnotationHelper(this.processingEnv);

    public InstanceStateHandler(ProcessingEnvironment processingEnvironment) {
        super(InstanceState.class, processingEnvironment);
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivityOrEFragment(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
        this.validatorHelper.canBePutInABundle(element, valid);
    }

    @Override
    public void process(Element element, HasInstanceState holder) {
        JClass elementClass = this.codeModelHelper.typeMirrorToJClass(element.asType(), holder);
        String fieldName = element.getSimpleName().toString();
        JBlock saveStateBody = holder.getSaveStateMethodBody();
        JVar saveStateBundleParam = holder.getSaveStateBundleParam();
        JMethod restoreStateMethod = holder.getRestoreStateMethod();
        JBlock restoreStateBody = restoreStateMethod.body();
        JVar restoreStateBundleParam = holder.getRestoreStateBundleParam();
        TypeMirror type = this.codeModelHelper.getActualType(element, holder);
        BundleHelper bundleHelper = new BundleHelper(this.annotationHelper, type);
        JFieldRef ref = JExpr.ref(fieldName);
        saveStateBody.invoke((JExpression)saveStateBundleParam, bundleHelper.getMethodNameToSave()).arg(fieldName).arg(ref);
        JExpression restoreMethodCall = bundleHelper.getExpressionToRestoreFromBundle(elementClass, restoreStateBundleParam, JExpr.lit(fieldName), restoreStateMethod, holder);
        restoreStateBody.assign(ref, restoreMethodCall);
    }
}

