/*
 * Decompiled with CFR 0.152.
 */
package org.androidannotations.handler;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JVar;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.androidannotations.annotations.Bean;
import org.androidannotations.annotations.NonConfigurationInstance;
import org.androidannotations.handler.BaseAnnotationHandler;
import org.androidannotations.helper.APTCodeModelHelper;
import org.androidannotations.helper.AnnotationHelper;
import org.androidannotations.holder.EActivityHolder;
import org.androidannotations.holder.NonConfigurationHolder;
import org.androidannotations.model.AnnotationElements;
import org.androidannotations.process.IsValid;

public class NonConfigurationInstanceHandler
extends BaseAnnotationHandler<EActivityHolder> {
    private final APTCodeModelHelper codeModelHelper;
    private final AnnotationHelper annotationHelper;

    public NonConfigurationInstanceHandler(ProcessingEnvironment processingEnvironment) {
        super(NonConfigurationInstance.class, processingEnvironment);
        this.annotationHelper = new AnnotationHelper(this.processingEnv);
        this.codeModelHelper = new APTCodeModelHelper();
    }

    @Override
    public void validate(Element element, AnnotationElements validatedElements, IsValid valid) {
        this.validatorHelper.enclosingElementHasEActivity(element, validatedElements, valid);
        this.validatorHelper.isNotPrivate(element, valid);
    }

    @Override
    public void process(Element element, EActivityHolder holder) throws JClassAlreadyExistsException {
        String fieldName = element.getSimpleName().toString();
        JClass fieldType = this.codeModelHelper.typeMirrorToJClass(element.asType(), holder);
        NonConfigurationHolder ncHolder = holder.getNonConfigurationHolder();
        JFieldVar ncHolderField = ncHolder.createField(fieldName, fieldType);
        this.injectInInit(element, holder, fieldName, ncHolderField);
        this.retainInOnRetain(holder, fieldName, ncHolderField);
    }

    private void injectInInit(Element element, EActivityHolder holder, String fieldName, JFieldVar ncHolderField) throws JClassAlreadyExistsException {
        JBlock initIfNonConfigurationNotNullBlock = holder.getInitIfNonConfigurationNotNullBlock();
        JVar initNonConfigurationInstance = holder.getInitNonConfigurationInstance();
        initIfNonConfigurationNotNullBlock.assign(JExpr.ref(fieldName), initNonConfigurationInstance.ref(ncHolderField));
        this.rebindContextIfBean(element, initIfNonConfigurationNotNullBlock, ncHolderField);
    }

    private void retainInOnRetain(EActivityHolder holder, String fieldName, JFieldVar ncHolderField) throws JClassAlreadyExistsException {
        JBlock onRetainNonConfigurationInstanceBindBlock = holder.getOnRetainNonConfigurationInstanceBindBlock();
        JVar onRetainNonConfigurationInstance = holder.getOnRetainNonConfigurationInstance();
        onRetainNonConfigurationInstanceBindBlock.assign(onRetainNonConfigurationInstance.ref(ncHolderField), JExpr.ref(fieldName));
    }

    private void rebindContextIfBean(Element element, JBlock initIfNonConfigurationNotNullBlock, JFieldVar field) {
        boolean hasBeanAnnotation;
        boolean bl = hasBeanAnnotation = element.getAnnotation(Bean.class) != null;
        if (hasBeanAnnotation) {
            TypeMirror elementType = this.annotationHelper.extractAnnotationClassParameter(element, Bean.class.getName());
            if (elementType == null) {
                elementType = element.asType();
            }
            String typeQualifiedName = elementType.toString();
            JClass fieldGeneratedBeanClass = this.refClass(typeQualifiedName + "_");
            initIfNonConfigurationNotNullBlock.invoke((JExpression)JExpr.cast(fieldGeneratedBeanClass, field), "rebind").arg(JExpr._this());
        }
    }
}

