/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.align.util;

import java.io.StringWriter;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.AtomImpl;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.jama.Matrix;

public final class RotationAxis {
    static final double MIN_ANGLE = Math.toRadians(5.0);
    private double theta;
    private Atom rotationAxis;
    private Atom rotationPos;
    private Atom screwTranslation;
    private Atom otherTranslation;

    public double getAngle() {
        return this.theta;
    }

    public Atom getRotationAxis() {
        return this.rotationAxis;
    }

    public AxisAngle4d getAxisAngle4d() {
        return new AxisAngle4d(this.rotationAxis.getX(), this.rotationAxis.getY(), this.rotationAxis.getZ(), this.theta);
    }

    public Atom getRotationPos() {
        return this.rotationPos;
    }

    public Atom getScrewTranslation() {
        return this.screwTranslation;
    }

    public Vector3d getVector3dScrewTranslation() {
        return new Vector3d(this.screwTranslation.getX(), this.screwTranslation.getY(), this.screwTranslation.getZ());
    }

    @Deprecated
    public Atom getOtherTranslation() {
        return this.otherTranslation;
    }

    public RotationAxis(AFPChain afpChain) throws StructureException {
        if (afpChain.getAlnLength() < 1) {
            throw new StructureException("No aligned residues");
        }
        this.init(afpChain.getBlockRotationMatrix()[0], afpChain.getBlockShiftVector()[0]);
    }

    public RotationAxis(Atom axis, Atom pos, double theta) {
        this.rotationAxis = Calc.unitVector(axis);
        this.rotationPos = (Atom)pos.clone();
        this.theta = theta;
        this.screwTranslation = new AtomImpl();
        this.otherTranslation = null;
    }

    public RotationAxis(Matrix rotation, Atom translation) {
        this.init(rotation, translation);
    }

    public RotationAxis(Matrix4d transform) {
        Matrix rot = Calc.getRotationMatrix(transform);
        Atom transl = Calc.getTranslationVector(transform);
        this.init(rot, transl);
    }

    public Matrix getRotationMatrix() {
        return this.getRotationMatrix(this.theta);
    }

    public Matrix getRotationMatrix(double theta) {
        if (this.rotationAxis == null) {
            return Matrix.identity(3, 3);
        }
        double x = this.rotationAxis.getX();
        double y = this.rotationAxis.getY();
        double z = this.rotationAxis.getZ();
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double com = 1.0 - cos;
        return new Matrix(new double[][]{{com * x * x + cos, com * x * y + sin * z, com * x * z + -sin * y}, {com * x * y - sin * z, com * y * y + cos, com * y * z + sin * x}, {com * x * z + sin * y, com * y * z - sin * x, com * z * z + cos}});
    }

    public int guessOrderFromAngle(double threshold, int maxOrder) {
        double bestDelta = threshold;
        int bestOrder = 1;
        for (int order = 2; order < maxOrder; ++order) {
            double delta = Math.abs(Math.PI * 2 / (double)order - this.theta);
            if (!(delta < bestDelta)) continue;
            bestOrder = order;
            bestDelta = delta;
        }
        return bestOrder;
    }

    public Matrix getFullMatrix() {
        return null;
    }

    private void init(Matrix rotation, Atom translation) {
        if (rotation.getColumnDimension() != 3 || rotation.getRowDimension() != 3) {
            throw new IllegalArgumentException("Expected 3x3 rotation matrix");
        }
        double c = (rotation.trace() - 1.0) / 2.0;
        if (-1.00000001 < c && c < -1.0) {
            c = -1.0;
        }
        if (1.00000001 > c && c > 1.0) {
            c = 1.0;
        }
        if (-1.0 > c || c > 1.0) {
            throw new IllegalArgumentException("Input matrix is not a valid rotation matrix.");
        }
        this.theta = Math.acos(c);
        if (this.theta < MIN_ANGLE) {
            this.calculateTranslationalAxis(rotation, translation);
        } else {
            this.calculateRotationalAxis(rotation, translation, c);
        }
    }

    private void calculateRotationalAxis(Matrix rotation, Atom translation, double c) {
        int i;
        double sum = 0.0;
        double[] rotAx = new double[3];
        for (i = 0; i < 3; ++i) {
            rotAx[i] = Math.sqrt(rotation.get(i, i) - c);
            sum += rotAx[i] * rotAx[i];
        }
        i = 0;
        while (i < 3) {
            int n = i++;
            rotAx[n] = rotAx[n] / Math.sqrt(sum);
        }
        double d0 = rotation.get(2, 1) - rotation.get(1, 2);
        double d1 = rotation.get(0, 2) - rotation.get(2, 0);
        double d2 = rotation.get(1, 0) - rotation.get(0, 1);
        double s12 = rotation.get(2, 1) + rotation.get(1, 2);
        double s02 = rotation.get(0, 2) + rotation.get(2, 0);
        double s01 = rotation.get(1, 0) + rotation.get(0, 1);
        if (Math.abs(d0) < Math.abs(d1)) {
            if (Math.abs(d1) < Math.abs(d2)) {
                if (d2 >= 0.0) {
                    if (s02 < 0.0) {
                        rotAx[0] = -rotAx[0];
                    }
                    if (s12 < 0.0) {
                        rotAx[1] = -rotAx[1];
                    }
                } else {
                    rotAx[2] = -rotAx[2];
                    if (s02 >= 0.0) {
                        rotAx[0] = -rotAx[0];
                    }
                    if (s12 >= 0.0) {
                        rotAx[1] = -rotAx[1];
                    }
                }
            } else if (d1 >= 0.0) {
                if (s01 < 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 < 0.0) {
                    rotAx[2] = -rotAx[2];
                }
            } else {
                rotAx[1] = -rotAx[1];
                if (s01 >= 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 >= 0.0) {
                    rotAx[2] = -rotAx[2];
                }
            }
        } else if (Math.abs(d0) < Math.abs(d2)) {
            if (d2 >= 0.0) {
                if (s02 < 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 < 0.0) {
                    rotAx[1] = -rotAx[1];
                }
            } else {
                rotAx[2] = -rotAx[2];
                if (s02 >= 0.0) {
                    rotAx[0] = -rotAx[0];
                }
                if (s12 >= 0.0) {
                    rotAx[1] = -rotAx[1];
                }
            }
        } else if (d0 >= 0.0) {
            if (s01 < 0.0) {
                rotAx[1] = -rotAx[1];
            }
            if (s02 < 0.0) {
                rotAx[2] = -rotAx[2];
            }
        } else {
            rotAx[0] = -rotAx[0];
            if (s01 >= 0.0) {
                rotAx[1] = -rotAx[1];
            }
            if (s02 >= 0.0) {
                rotAx[2] = -rotAx[2];
            }
        }
        this.rotationAxis = new AtomImpl();
        this.rotationAxis.setCoords(rotAx);
        double dotProduct = Calc.scalarProduct(this.rotationAxis, translation);
        this.screwTranslation = Calc.scale(this.rotationAxis, dotProduct);
        this.otherTranslation = Calc.subtract(translation, this.screwTranslation);
        Atom hypot = Calc.vectorProduct(this.otherTranslation, this.rotationAxis);
        Calc.scaleEquals(hypot, 0.5 / Math.tan(this.theta / 2.0));
        this.rotationPos = Calc.scaleAdd(0.5, this.otherTranslation, hypot);
    }

    private void calculateTranslationalAxis(Matrix rotation, Atom translation) {
        this.rotationAxis = Calc.scale(translation, 1.0 / Calc.amount(translation));
        this.rotationPos = null;
        this.screwTranslation = translation;
        this.otherTranslation = new AtomImpl();
        this.otherTranslation.setCoords(new double[]{0.0, 0.0, 0.0});
    }

    public String getJmolScript(Atom[] atoms) {
        return this.getJmolScript(atoms, 0);
    }

    public String getJmolScript(Atom[] atoms, int axisID) {
        boolean positiveScrew;
        Atom axialPt;
        double max;
        double width = 0.5;
        String axisColor = "yellow";
        String screwColor = "orange";
        double min = max = Calc.scalarProduct(this.rotationAxis, atoms[0]);
        for (int i = 1; i < atoms.length; ++i) {
            double prod = Calc.scalarProduct(this.rotationAxis, atoms[i]);
            if (prod < min) {
                min = prod;
            }
            if (!(prod > max)) continue;
            max = prod;
        }
        double uLen = Calc.scalarProduct(this.rotationAxis, this.rotationAxis);
        min /= uLen;
        max /= uLen;
        if (this.rotationPos == null) {
            Atom center = Calc.centerOfMass(atoms);
            Atom centerOnAxis = Calc.scale(this.rotationAxis, Calc.scalarProduct(center, this.rotationAxis));
            axialPt = Calc.subtract(center, centerOnAxis);
        } else {
            axialPt = this.rotationPos;
        }
        Atom axisMin = (Atom)axialPt.clone();
        Calc.scaleAdd(min, this.rotationAxis, axisMin);
        Atom axisMax = (Atom)axialPt.clone();
        Calc.scaleAdd(max, this.rotationAxis, axisMax);
        StringWriter result = new StringWriter();
        result.append("set defaultDrawArrowScale 2.0;");
        result.append(String.format("draw ID rot" + axisID + " CYLINDER {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), axisMax.getX(), axisMax.getY(), axisMax.getZ(), 0.5, "yellow"));
        boolean bl = positiveScrew = Math.signum(this.rotationAxis.getX()) == Math.signum(this.screwTranslation.getX());
        if (positiveScrew) {
            result.append(String.format("draw ID screw" + axisID + " VECTOR {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMax.getX(), axisMax.getY(), axisMax.getZ(), this.screwTranslation.getX(), this.screwTranslation.getY(), this.screwTranslation.getZ(), 0.5, "orange"));
        } else {
            result.append(String.format("draw ID screw" + axisID + " VECTOR {%f,%f,%f} {%f,%f,%f} WIDTH %f COLOR %s ;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), this.screwTranslation.getX(), this.screwTranslation.getY(), this.screwTranslation.getZ(), 0.5, "orange"));
        }
        if (this.rotationPos != null) {
            result.append(System.getProperty("line.separator"));
            result.append(String.format("draw ID rotArc" + axisID + " ARC {%f,%f,%f} {%f,%f,%f} {0,0,0} {0,%f,%d} SCALE 500 DIAMETER %f COLOR %s;", axisMin.getX(), axisMin.getY(), axisMin.getZ(), axisMax.getX(), axisMax.getY(), axisMax.getZ(), Math.toDegrees(this.theta), positiveScrew ? 0 : 1, 0.5, "yellow"));
        }
        return result.toString();
    }

    public Atom getProjectedPoint(Atom point) {
        if (this.rotationPos == null) {
            return null;
        }
        Atom localPoint = Calc.subtract(point, this.rotationPos);
        double dot = Calc.scalarProduct(localPoint, this.rotationAxis);
        Atom localProjected = Calc.scale(this.rotationAxis, dot);
        Atom projected = Calc.add(localProjected, this.rotationPos);
        return projected;
    }

    public double getProjectedDistance(Atom point) {
        Atom projected = this.getProjectedPoint(point);
        if (projected == null) {
            return Double.NaN;
        }
        return Calc.getDistance(point, projected);
    }

    public void rotate(Atom[] atoms, double theta) {
        Matrix rot = this.getRotationMatrix(theta);
        if (this.rotationPos == null) {
            return;
        }
        Atom negPos = Calc.invert(this.rotationPos);
        for (Atom a : atoms) {
            Calc.shift(a, negPos);
        }
        Calc.rotate(atoms, rot);
        for (Atom a : atoms) {
            Calc.shift(a, this.rotationPos);
        }
    }

    public static double getAngle(AFPChain afpChain) throws StructureException {
        if (afpChain.getBlockNum() < 1) {
            throw new StructureException("No aligned residues");
        }
        Matrix rotation = afpChain.getBlockRotationMatrix()[0];
        if (rotation == null) {
            throw new NullPointerException("AFPChain does not contain a rotation matrix");
        }
        return RotationAxis.getAngle(rotation);
    }

    public static double getAngle(Matrix rotation) {
        double c = (rotation.trace() - 1.0) / 2.0;
        return Math.acos(c);
    }

    public boolean isDefined() {
        return this.rotationPos != null;
    }
}

