/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.biojava.nbio.structure.Bond;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.ChainImpl;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.ExperimentalTechnique;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.JournalArticle;
import org.biojava.nbio.structure.Model;
import org.biojava.nbio.structure.PDBCrystallographicInfo;
import org.biojava.nbio.structure.PDBHeader;
import org.biojava.nbio.structure.PdbId;
import org.biojava.nbio.structure.ResidueNumber;
import org.biojava.nbio.structure.ResidueRange;
import org.biojava.nbio.structure.Site;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.StructureIdentifier;
import org.biojava.nbio.structure.SubstructureIdentifier;
import org.biojava.nbio.structure.io.FileConvert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureImpl
implements Structure {
    private static final long serialVersionUID = -8344837138032851348L;
    private static final Logger logger = LoggerFactory.getLogger(StructureImpl.class);
    private PdbId pdbId;
    private List<Model> models = new ArrayList<Model>();
    private List<EntityInfo> entityInfos = new ArrayList<EntityInfo>();
    private List<DBRef> dbrefs = new ArrayList<DBRef>();
    private List<Bond> ssbonds;
    private List<Site> sites;
    private String name = "";
    private StructureIdentifier structureIdentifier;
    private PDBHeader pdbHeader = new PDBHeader();
    private boolean biologicalAssembly;

    public StructureImpl() {
        this.ssbonds = new ArrayList<Bond>();
        this.sites = new ArrayList<Site>();
    }

    public StructureImpl(Group g) {
        this();
        ChainImpl c = new ChainImpl();
        c.addGroup(g);
        this.addChain(c);
    }

    public StructureImpl(Chain c) {
        this();
        this.addChain(c);
    }

    @Override
    public Structure clone() {
        StructureImpl n = new StructureImpl();
        n.setPdbId(this.getPdbId());
        n.setName(this.getName());
        n.setPDBHeader(this.pdbHeader);
        n.setDBRefs(this.getDBRefs());
        n.setSites(this.getSites());
        for (int i = 0; i < this.nrModels(); ++i) {
            ArrayList<Chain> cloned_model = new ArrayList<Chain>();
            for (int j = 0; j < this.size(i); ++j) {
                Chain cloned_chain = (Chain)this.getChainByIndex(i, j).clone();
                cloned_chain.setStructure(n);
                cloned_model.add(cloned_chain);
            }
            n.addModel(cloned_model);
        }
        ArrayList<EntityInfo> newEntityInfoList = new ArrayList<EntityInfo>();
        for (EntityInfo entityInfo : this.entityInfos) {
            EntityInfo newEntityInfo = new EntityInfo(entityInfo);
            for (String asymId : entityInfo.getChainIds()) {
                for (int modelNr = 0; modelNr < n.nrModels(); ++modelNr) {
                    Chain newChain = n.getChain(asymId, modelNr);
                    if (newChain == null) {
                        logger.warn("Could not find chain asymId " + asymId + " of model " + modelNr + " while cloning entityInfo " + entityInfo.getMolId() + ". Something is wrong!");
                        continue;
                    }
                    newChain.setEntityInfo(newEntityInfo);
                    newEntityInfo.addChain(newChain);
                }
            }
            newEntityInfoList.add(newEntityInfo);
        }
        n.setEntityInfos(newEntityInfoList);
        return n;
    }

    @Override
    public Group findGroup(String chainName, String pdbResnum, int modelIdx) throws StructureException {
        if (modelIdx > this.models.size()) {
            throw new StructureException(" no model nr " + modelIdx + " in this structure. (contains " + this.models.size() + ")");
        }
        Chain polyChain = this.getPolyChainByPDB(chainName, modelIdx);
        if (polyChain != null) {
            ArrayList<Group> groups = new ArrayList<Group>(polyChain.getAtomGroups());
            for (Chain chain : this.getNonPolyChainsByPDB(chainName, modelIdx)) {
                groups.addAll(chain.getAtomGroups());
            }
            Chain water = this.getWaterChainByPDB(chainName, modelIdx);
            if (water != null) {
                groups.addAll(water.getAtomGroups());
            }
            for (Group g : groups) {
                String rnum = g.getResidueNumber().toString();
                if (!rnum.equals(pdbResnum)) continue;
                return g;
            }
        }
        throw new StructureException("could not find group " + pdbResnum + " in chain " + chainName);
    }

    @Override
    public Group findGroup(String chainName, String pdbResnum) throws StructureException {
        return this.findGroup(chainName, pdbResnum, 0);
    }

    @Override
    public void setName(String nam) {
        this.name = nam;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public StructureIdentifier getStructureIdentifier() {
        return this.structureIdentifier;
    }

    @Override
    public void setStructureIdentifier(StructureIdentifier structureIdentifier) {
        this.structureIdentifier = structureIdentifier;
    }

    @Override
    public void addChain(Chain chain) {
        this.addChain(chain, 0);
    }

    @Override
    public void addChain(Chain chain, int modelIdx) {
        chain.setStructure(this);
        if (this.models.isEmpty()) {
            Model model = new Model();
            ArrayList<Chain> modelChains = new ArrayList<Chain>();
            modelChains.add(chain);
            model.setChains(modelChains);
            this.models.add(model);
        } else {
            Model model = this.models.get(modelIdx);
            model.addChain(chain);
        }
    }

    @Override
    public Chain getChainByIndex(int number) {
        return this.getChainByIndex(0, number);
    }

    @Override
    public Chain getChainByIndex(int modelIdx, int number) {
        Model model = this.models.get(modelIdx);
        return model.getChains().get(number);
    }

    @Override
    public void addModel(List<Chain> modelChains) {
        for (Chain c : modelChains) {
            c.setStructure(this);
        }
        Model model = new Model();
        model.setChains(modelChains);
        this.models.add(model);
    }

    @Override
    public void setChains(List<Chain> chains) {
        this.setModel(0, chains);
    }

    @Override
    public void setModel(int position, List<Chain> modelChains) {
        if (modelChains == null) {
            throw new IllegalArgumentException("trying to set model to null!");
        }
        for (Chain c : modelChains) {
            c.setStructure(this);
        }
        Model model = new Model();
        model.setChains(modelChains);
        if (this.models.isEmpty()) {
            this.models.add(model);
        } else {
            this.models.set(position, model);
        }
    }

    @Override
    public String toString() {
        String newline = System.lineSeparator();
        StringBuilder str = new StringBuilder();
        str.append("structure ");
        str.append(this.name);
        str.append(" ");
        str.append(this.pdbId);
        str.append(" ");
        if (this.nrModels() > 1) {
            str.append(" models: ");
            str.append(this.nrModels());
            str.append(newline);
        }
        str.append(this.pdbHeader);
        str.append(newline);
        for (int i = 0; i < this.nrModels(); ++i) {
            if (this.nrModels() > 1) {
                str.append(" model[");
                str.append(i);
                str.append("]:");
                str.append(newline);
            }
            str.append(" chains:");
            str.append(newline);
            for (int j = 0; j < this.size(i); ++j) {
                Chain cha = this.getChainByIndex(i, j);
                List<Group> agr = cha.getAtomGroups(GroupType.AMINOACID);
                List<Group> hgr = cha.getAtomGroups(GroupType.HETATM);
                List<Group> ngr = cha.getAtomGroups(GroupType.NUCLEOTIDE);
                str.append("chain ").append(j).append(": asymId:").append(cha.getId()).append(" authId:").append(cha.getName()).append(" ");
                if (cha.getEntityInfo() != null) {
                    EntityInfo comp = cha.getEntityInfo();
                    String molName = comp.getDescription();
                    if (molName != null) {
                        str.append(molName);
                    }
                    String type = comp.getType().toString();
                    str.append(" (").append(type).append(")");
                }
                str.append(newline);
                str.append(" length SEQRES: ").append(cha.getSeqResLength());
                str.append(" length ATOM: ").append(cha.getAtomLength());
                str.append(" aminos: ").append(agr.size());
                str.append(" hetatms: ").append(hgr.size());
                str.append(" nucleotides: ").append(ngr.size()).append(newline);
            }
        }
        str.append("DBRefs: ").append(this.dbrefs.size()).append(newline);
        for (DBRef dbref : this.dbrefs) {
            str.append(dbref.toPDB()).append(newline);
        }
        str.append("Molecules: ").append(newline);
        for (EntityInfo mol : this.entityInfos) {
            str.append(mol).append(newline);
        }
        return str.toString();
    }

    @Override
    public int size() {
        if (!this.models.isEmpty()) {
            return this.models.get(0).getPolyChains().size();
        }
        return 0;
    }

    @Override
    public int size(int modelIdx) {
        return this.models.get(modelIdx).size();
    }

    @Override
    public int nrModels() {
        return this.models.size();
    }

    @Override
    public boolean isCrystallographic() {
        if (this.pdbHeader.getExperimentalTechniques() != null) {
            return ExperimentalTechnique.isCrystallographic(this.pdbHeader.getExperimentalTechniques());
        }
        if (this.pdbHeader.getCrystallographicInfo().getSpaceGroup() != null) {
            return this.pdbHeader.getCrystallographicInfo().getCrystalCell() != null && this.pdbHeader.getCrystallographicInfo().getCrystalCell().isCellReasonable();
        }
        return false;
    }

    @Override
    public boolean isNmr() {
        if (this.pdbHeader.getExperimentalTechniques() != null) {
            return ExperimentalTechnique.isNmr(this.pdbHeader.getExperimentalTechniques());
        }
        if (this.nrModels() > 1) {
            if (this.pdbHeader.getCrystallographicInfo().getSpaceGroup() != null) {
                if (this.pdbHeader.getCrystallographicInfo().getCrystalCell() == null) {
                    return true;
                }
                if (!this.pdbHeader.getCrystallographicInfo().getCrystalCell().isCellReasonable()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Chain> getChains(int modelIdx) {
        return this.getModel(modelIdx);
    }

    @Override
    public List<Chain> getChains() {
        if (this.models.isEmpty()) {
            return new ArrayList<Chain>(0);
        }
        return this.getChains(0);
    }

    @Override
    public List<Chain> getPolyChains() {
        if (this.models.isEmpty()) {
            return new ArrayList<Chain>(0);
        }
        return this.getPolyChains(0);
    }

    @Override
    public List<Chain> getPolyChains(int modelIdx) {
        return this.models.get(modelIdx).getPolyChains();
    }

    @Override
    public List<Chain> getNonPolyChains() {
        if (this.models.isEmpty()) {
            return new ArrayList<Chain>(0);
        }
        return this.getNonPolyChains(0);
    }

    @Override
    public List<Chain> getNonPolyChains(int modelIdx) {
        return this.models.get(modelIdx).getNonPolyChains();
    }

    @Override
    public List<Chain> getWaterChains() {
        if (this.models.isEmpty()) {
            return new ArrayList<Chain>(0);
        }
        return this.getWaterChains(0);
    }

    @Override
    public List<Chain> getWaterChains(int modelIdx) {
        return this.models.get(modelIdx).getWaterChains();
    }

    @Override
    public void setChains(int modelIdx, List<Chain> chains) {
        for (Chain c : chains) {
            c.setStructure(this);
        }
        if (this.models.size() > modelIdx) {
            this.models.remove(modelIdx);
        }
        Model model = new Model();
        model.setChains(chains);
        this.models.add(modelIdx, model);
    }

    @Override
    public List<Chain> getModel(int modelIdx) {
        if (this.models.isEmpty()) {
            return new ArrayList<Chain>();
        }
        return this.models.get(modelIdx).getChains();
    }

    @Override
    public Chain getChain(String asymId, int modelIdx) {
        List<Chain> chains = this.getChains(modelIdx);
        for (Chain c : chains) {
            if (!c.getId().equals(asymId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Chain getChain(String asymId) {
        return this.getChain(asymId, 0);
    }

    @Override
    public Chain getPolyChain(String asymId) {
        return this.getPolyChain(asymId, 0);
    }

    @Override
    public Chain getPolyChain(String asymId, int modelIdx) {
        if (this.models.isEmpty()) {
            return null;
        }
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return null;
        }
        List<Chain> polyChains = model.getPolyChains();
        for (Chain c : polyChains) {
            if (!c.getId().equals(asymId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Chain getNonPolyChain(String asymId) {
        return this.getNonPolyChain(asymId, 0);
    }

    @Override
    public Chain getNonPolyChain(String asymId, int modelIdx) {
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return null;
        }
        List<Chain> nonpolyChains = model.getNonPolyChains();
        for (Chain c : nonpolyChains) {
            if (!c.getId().equals(asymId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Chain getPolyChainByPDB(String authId) {
        return this.getPolyChainByPDB(authId, 0);
    }

    @Override
    public Chain getPolyChainByPDB(String authId, int modelIdx) {
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return null;
        }
        List<Chain> polyChains = model.getPolyChains();
        for (Chain c : polyChains) {
            if (!c.getName().equals(authId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public List<Chain> getNonPolyChainsByPDB(String authId) {
        return this.getNonPolyChainsByPDB(authId, 0);
    }

    @Override
    public List<Chain> getNonPolyChainsByPDB(String authId, int modelIdx) {
        ArrayList<Chain> chains = new ArrayList<Chain>();
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return chains;
        }
        List<Chain> nonpolyChains = model.getNonPolyChains();
        for (Chain c : nonpolyChains) {
            if (!c.getName().equals(authId)) continue;
            chains.add(c);
        }
        return chains;
    }

    @Override
    public Chain getWaterChain(String asymId) {
        return this.getWaterChain(asymId, 0);
    }

    @Override
    public Chain getWaterChain(String asymId, int modelIdx) {
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return null;
        }
        List<Chain> waterChains = model.getWaterChains();
        for (Chain c : waterChains) {
            if (!c.getId().equals(asymId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Chain getWaterChainByPDB(String authId) {
        return this.getWaterChainByPDB(authId, 0);
    }

    @Override
    public Chain getWaterChainByPDB(String authId, int modelIdx) {
        Model model = this.models.get(modelIdx);
        if (model == null) {
            return null;
        }
        List<Chain> waterChains = model.getWaterChains();
        for (Chain c : waterChains) {
            if (!c.getName().equals(authId)) continue;
            return c;
        }
        return null;
    }

    @Override
    public String toPDB() {
        FileConvert f = new FileConvert(this);
        return f.toPDB();
    }

    @Override
    public String toMMCIF() {
        FileConvert f = new FileConvert(this);
        return f.toMMCIF();
    }

    @Override
    public boolean hasChain(String authId) {
        int modelnr = 0;
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getId().equals(authId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasNonPolyChain(String asymId) {
        int modelnr = 0;
        List<Chain> chains = this.models.get(modelnr).getNonPolyChains();
        for (Chain c : chains) {
            if (!c.getId().equals(asymId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPdbChain(String authId) {
        int modelnr = 0;
        List<Chain> chains = this.getChains(modelnr);
        for (Chain c : chains) {
            if (!c.getName().equals(authId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setEntityInfos(List<EntityInfo> molList) {
        this.entityInfos = molList;
    }

    @Override
    public void addEntityInfo(EntityInfo entityInfo) {
        this.entityInfos.add(entityInfo);
    }

    @Override
    public List<EntityInfo> getEntityInfos() {
        return this.entityInfos;
    }

    @Override
    public EntityInfo getEntityById(int entityId) {
        for (EntityInfo mol : this.entityInfos) {
            if (mol.getMolId() != entityId) continue;
            return mol;
        }
        return null;
    }

    @Override
    public List<DBRef> getDBRefs() {
        return this.dbrefs;
    }

    @Override
    public void setDBRefs(List<DBRef> dbrefs) {
        if (dbrefs == null) {
            throw new IllegalArgumentException("trying to set dbrefs to null!");
        }
        for (DBRef ref : dbrefs) {
            ref.setParent(this);
        }
        this.dbrefs = dbrefs;
    }

    @Override
    public PDBHeader getPDBHeader() {
        return this.pdbHeader;
    }

    @Override
    public void setPDBHeader(PDBHeader pdbHeader) {
        this.pdbHeader = pdbHeader;
    }

    @Override
    public List<Bond> getSSBonds() {
        return this.ssbonds;
    }

    @Override
    public void setSSBonds(List<Bond> ssbonds) {
        this.ssbonds = ssbonds;
    }

    @Override
    public void addSSBond(Bond ssbond) {
        this.ssbonds.add(ssbond);
    }

    @Override
    public boolean hasJournalArticle() {
        return this.pdbHeader.hasJournalArticle();
    }

    @Override
    public JournalArticle getJournalArticle() {
        return this.pdbHeader.getJournalArticle();
    }

    @Override
    public void setJournalArticle(JournalArticle journalArticle) {
        this.pdbHeader.setJournalArticle(journalArticle);
    }

    @Override
    public List<Site> getSites() {
        return this.sites;
    }

    @Override
    public void setSites(List<Site> sites) {
        this.sites = sites;
    }

    @Override
    public void setBiologicalAssembly(boolean biologicalAssembly) {
        this.biologicalAssembly = biologicalAssembly;
    }

    @Override
    public boolean isBiologicalAssembly() {
        return this.biologicalAssembly;
    }

    @Override
    public void setCrystallographicInfo(PDBCrystallographicInfo crystallographicInfo) {
        this.pdbHeader.setCrystallographicInfo(crystallographicInfo);
    }

    @Override
    public PDBCrystallographicInfo getCrystallographicInfo() {
        return this.pdbHeader.getCrystallographicInfo();
    }

    @Override
    public String getIdentifier() {
        if (this.getStructureIdentifier() != null) {
            return this.getStructureIdentifier().getIdentifier();
        }
        if (this.getName() != null) {
            return this.getName();
        }
        return this.toCanonical().getIdentifier();
    }

    @Override
    @Deprecated
    public String getPDBCode() {
        if (this.pdbId == null) {
            return null;
        }
        return this.pdbId.getId();
    }

    @Override
    @Deprecated
    public void setPDBCode(String pdb_id) {
        this.pdbId = pdb_id == null ? null : new PdbId(pdb_id);
    }

    @Override
    public PdbId getPdbId() {
        return this.pdbId;
    }

    @Override
    public void setPdbId(PdbId pdbId) {
        this.pdbId = pdbId;
    }

    @Override
    public void resetModels() {
        this.models = new ArrayList<Model>();
    }

    private SubstructureIdentifier toCanonical() {
        StructureIdentifier real = this.getStructureIdentifier();
        if (real != null) {
            try {
                return real.toCanonical();
            }
            catch (StructureException structureException) {
                // empty catch block
            }
        }
        ArrayList<ResidueRange> range = new ArrayList<ResidueRange>();
        for (Chain chain : this.getChains()) {
            List<Group> groups = chain.getAtomGroups();
            ListIterator<Group> groupsIt = groups.listIterator();
            if (!groupsIt.hasNext()) continue;
            Group g = groupsIt.next();
            ResidueNumber first = g.getResidueNumber();
            while (groupsIt.hasNext()) {
                g = groupsIt.next();
            }
            ResidueNumber last = g.getResidueNumber();
            range.add(new ResidueRange(chain.getName(), first, last));
        }
        return new SubstructureIdentifier(this.getPdbId(), range);
    }
}

