/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.structure.cluster;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.biojava.nbio.alignment.Alignments;
import org.biojava.nbio.alignment.SimpleGapPenalty;
import org.biojava.nbio.alignment.template.GapPenalty;
import org.biojava.nbio.alignment.template.PairwiseSequenceAligner;
import org.biojava.nbio.core.alignment.matrices.SubstitutionMatrixHelper;
import org.biojava.nbio.core.alignment.template.SubstitutionMatrix;
import org.biojava.nbio.core.exceptions.CompoundNotFoundException;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.core.sequence.compound.AminoAcidCompound;
import org.biojava.nbio.core.sequence.template.Sequence;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.StructureException;
import org.biojava.nbio.structure.align.StructureAlignment;
import org.biojava.nbio.structure.align.StructureAlignmentFactory;
import org.biojava.nbio.structure.align.ce.ConfigStrucAligParams;
import org.biojava.nbio.structure.align.model.AFPChain;
import org.biojava.nbio.structure.align.multiple.BlockImpl;
import org.biojava.nbio.structure.align.multiple.BlockSetImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignment;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentEnsembleImpl;
import org.biojava.nbio.structure.align.multiple.MultipleAlignmentImpl;
import org.biojava.nbio.structure.align.multiple.util.MultipleAlignmentScorer;
import org.biojava.nbio.structure.align.multiple.util.ReferenceSuperimposer;
import org.biojava.nbio.structure.cluster.Subunit;
import org.biojava.nbio.structure.cluster.SubunitClustererMethod;
import org.biojava.nbio.structure.cluster.SubunitClustererParameters;
import org.biojava.nbio.structure.symmetry.internal.CESymmParameters;
import org.biojava.nbio.structure.symmetry.internal.CeSymm;
import org.biojava.nbio.structure.symmetry.internal.CeSymmResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubunitCluster {
    private static final Logger logger = LoggerFactory.getLogger(SubunitCluster.class);
    private List<Subunit> subunits = new ArrayList<Subunit>();
    private List<List<Integer>> subunitEQR = new ArrayList<List<Integer>>();
    private int representative = -1;
    private SubunitClustererMethod method = SubunitClustererMethod.SEQUENCE;
    private boolean pseudoStoichiometric = false;
    private String alpha = "";

    public String getAlpha() {
        return this.alpha;
    }

    public void setAlpha(String alpha) {
        this.alpha = alpha;
    }

    public SubunitCluster(Subunit subunit) {
        this.subunits.add(subunit);
        ArrayList<Integer> identity = new ArrayList<Integer>();
        for (int i = 0; i < subunit.size(); ++i) {
            identity.add(i);
        }
        this.subunitEQR.add(identity);
        this.representative = 0;
    }

    public SubunitCluster(SubunitCluster other, List<Integer> subunitsToRetain) {
        int i;
        this.method = other.method;
        this.pseudoStoichiometric = other.pseudoStoichiometric;
        for (i = 0; i < other.subunits.size(); ++i) {
            if (!subunitsToRetain.contains(i)) continue;
            this.subunits.add(other.subunits.get(i));
            this.subunitEQR.add(other.subunitEQR.get(i));
        }
        this.representative = 0;
        for (i = 1; i < this.subunits.size(); ++i) {
            if (this.subunits.get(i).size() <= this.subunits.get(this.representative).size()) continue;
            this.representative = i;
        }
        this.setAlpha(other.getAlpha());
    }

    public SubunitCluster(List<Subunit> subunits, List<List<Integer>> subunitEQR) {
        if (subunits.size() != subunitEQR.size()) {
            throw new IllegalArgumentException("Mismatched subunit length");
        }
        this.subunits = subunits;
        this.subunitEQR = subunitEQR;
        this.representative = 0;
        this.method = SubunitClustererMethod.MANUAL;
        this.pseudoStoichiometric = false;
    }

    public List<Subunit> getSubunits() {
        return Collections.unmodifiableList(this.subunits);
    }

    public boolean isIdenticalTo(SubunitCluster other) {
        String thisSequence = this.subunits.get(this.representative).getProteinSequenceString();
        String otherSequence = other.subunits.get(other.representative).getProteinSequenceString();
        return thisSequence.equals(otherSequence);
    }

    public boolean isIdenticalByEntityIdTo(SubunitCluster other) {
        int otherEntityId;
        Subunit thisSub = this.subunits.get(this.representative);
        Subunit otherSub = other.subunits.get(other.representative);
        String thisName = thisSub.getName();
        String otherName = otherSub.getName();
        Structure thisStruct = thisSub.getStructure();
        Structure otherStruct = otherSub.getStructure();
        if (thisStruct == null || otherStruct == null) {
            logger.info("SubunitClusters {}-{} have no referenced structures. Ignoring identity check by entity id", (Object)thisName, (Object)otherName);
            return false;
        }
        if (thisStruct != otherStruct) {
            return false;
        }
        Chain thisChain = thisStruct.getChain(thisName);
        Chain otherChain = otherStruct.getChain(otherName);
        if (thisChain == null || otherChain == null) {
            logger.info("Can't determine entity ids of SubunitClusters {}-{}. Ignoring identity check by entity id", (Object)thisName, (Object)otherName);
            return false;
        }
        if (thisChain.getEntityInfo() == null || otherChain.getEntityInfo() == null) {
            logger.info("Can't determine entity ids of SubunitClusters {}-{}. Ignoring identity check by entity id", (Object)thisName, (Object)otherName);
            return false;
        }
        int thisEntityId = thisChain.getEntityInfo().getMolId();
        return thisEntityId == (otherEntityId = otherChain.getEntityInfo().getMolId());
    }

    public boolean mergeIdentical(SubunitCluster other) {
        if (!this.isIdenticalTo(other)) {
            return false;
        }
        logger.info("SubunitClusters {}-{} are identical in sequence", (Object)this.subunits.get(this.representative).getName(), (Object)other.subunits.get(other.representative).getName());
        this.subunits.addAll(other.subunits);
        this.subunitEQR.addAll(other.subunitEQR);
        return true;
    }

    public boolean mergeIdenticalByEntityId(SubunitCluster other) {
        if (!this.isIdenticalByEntityIdTo(other)) {
            return false;
        }
        Subunit thisSub = this.subunits.get(this.representative);
        Subunit otherSub = other.subunits.get(other.representative);
        String thisName = thisSub.getName();
        String otherName = otherSub.getName();
        logger.info("SubunitClusters {}-{} belong to same entity. Assuming they are identical", (Object)thisName, (Object)otherName);
        ArrayList<Integer> thisAligned = new ArrayList<Integer>();
        ArrayList<Integer> otherAligned = new ArrayList<Integer>();
        Structure thisStruct = thisSub.getStructure();
        Structure otherStruct = otherSub.getStructure();
        Chain thisChain = thisStruct.getChain(thisName);
        Chain otherChain = otherStruct.getChain(otherName);
        EntityInfo entityInfo = thisChain.getEntityInfo();
        for (int thisIndex = 0; thisIndex < thisSub.size(); ++thisIndex) {
            Group g = thisSub.getRepresentativeAtoms()[thisIndex].getGroup();
            int seqresIndex = entityInfo.getAlignedResIndex(g, thisChain);
            if (seqresIndex == -1) continue;
            Group otherG = otherChain.getSeqResGroups().get(seqresIndex - 1);
            int otherIndex = otherChain.getAtomGroups().indexOf(otherG);
            if (otherIndex == -1 || !this.subunitEQR.get(this.representative).contains(thisIndex) || !other.subunitEQR.get(other.representative).contains(otherIndex)) continue;
            thisAligned.add(thisIndex);
            otherAligned.add(otherIndex);
        }
        if (thisAligned.isEmpty() && otherAligned.isEmpty()) {
            logger.warn("No equivalent aligned atoms found between SubunitClusters {}-{} via entity SEQRES alignment. Is FileParsingParameters.setAlignSeqRes() set?", (Object)thisName, (Object)otherName);
        }
        this.updateEquivResidues(other, thisAligned, otherAligned);
        return true;
    }

    public boolean mergeSequence(SubunitCluster other, SubunitClustererParameters params) throws CompoundNotFoundException {
        Alignments.PairwiseSequenceAlignerType alignerType = Alignments.PairwiseSequenceAlignerType.LOCAL;
        if (params.isUseGlobalMetrics()) {
            alignerType = Alignments.PairwiseSequenceAlignerType.GLOBAL;
        }
        return this.mergeSequence(other, params, alignerType, (GapPenalty)new SimpleGapPenalty(), (SubstitutionMatrix<AminoAcidCompound>)SubstitutionMatrixHelper.getBlosum62());
    }

    public boolean mergeSequence(SubunitCluster other, SubunitClustererParameters params, Alignments.PairwiseSequenceAlignerType alignerType, GapPenalty gapPenalty, SubstitutionMatrix<AminoAcidCompound> subsMatrix) throws CompoundNotFoundException {
        ProteinSequence thisSequence = this.subunits.get(this.representative).getProteinSequence();
        ProteinSequence otherSequence = other.subunits.get(other.representative).getProteinSequence();
        PairwiseSequenceAligner aligner = Alignments.getPairwiseAligner((Sequence)thisSequence, (Sequence)otherSequence, (Alignments.PairwiseSequenceAlignerType)alignerType, (GapPenalty)gapPenalty, subsMatrix);
        double sequenceIdentity = params.isUseGlobalMetrics() ? aligner.getPair().getPercentageOfIdentity(true) : aligner.getPair().getPercentageOfIdentity(false);
        if (sequenceIdentity < params.getSequenceIdentityThreshold()) {
            return false;
        }
        double sequenceCoverage = 0.0;
        if (params.isUseSequenceCoverage()) {
            double lengthOther;
            double lengthThis;
            double gaps1 = aligner.getPair().getAlignedSequence(1).getNumGapPositions();
            double gaps2 = aligner.getPair().getAlignedSequence(2).getNumGapPositions();
            double lengthAlignment = aligner.getPair().getLength();
            sequenceCoverage = (lengthAlignment - gaps1 - gaps2) / Math.max(lengthThis = (double)((ProteinSequence)aligner.getQuery()).getLength(), lengthOther = (double)((ProteinSequence)aligner.getTarget()).getLength());
            if (sequenceCoverage < params.getSequenceCoverageThreshold()) {
                return false;
            }
        }
        logger.info(String.format("SubunitClusters %s-%s are similar in sequence with %.2f sequence identity and %.2f coverage", this.subunits.get(this.representative).getName(), other.subunits.get(other.representative).getName(), sequenceIdentity, sequenceCoverage));
        ArrayList<Integer> thisAligned = new ArrayList<Integer>();
        ArrayList<Integer> otherAligned = new ArrayList<Integer>();
        for (int p = 1; p < aligner.getPair().getLength() + 1; ++p) {
            if (aligner.getPair().getAlignedSequence(1).isGap(p) || aligner.getPair().getAlignedSequence(2).isGap(p)) continue;
            int thisIndex = aligner.getPair().getIndexInQueryAt(p) - 1;
            int otherIndex = aligner.getPair().getIndexInTargetAt(p) - 1;
            if (!this.subunitEQR.get(this.representative).contains(thisIndex) || !other.subunitEQR.get(other.representative).contains(otherIndex)) continue;
            thisAligned.add(thisIndex);
            otherAligned.add(otherIndex);
        }
        this.updateEquivResidues(other, thisAligned, otherAligned);
        this.method = SubunitClustererMethod.SEQUENCE;
        this.pseudoStoichiometric = !params.isHighConfidenceScores(sequenceIdentity, sequenceCoverage);
        return true;
    }

    public boolean mergeStructure(SubunitCluster other, SubunitClustererParameters params) throws StructureException {
        StructureAlignment aligner = StructureAlignmentFactory.getAlgorithm(params.getSuperpositionAlgorithm());
        ConfigStrucAligParams aligner_params = aligner.getParameters();
        Method setOptimizeAlignment = null;
        try {
            setOptimizeAlignment = aligner_params.getClass().getMethod("setOptimizeAlignment", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (setOptimizeAlignment != null) {
            try {
                setOptimizeAlignment.invoke((Object)aligner_params, params.isOptimizeAlignment());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.warn("Could not set alignment optimisation switch");
            }
        }
        AFPChain afp = aligner.align(this.subunits.get(this.representative).getRepresentativeAtoms(), other.subunits.get(other.representative).getRepresentativeAtoms());
        String pairName = this.subunits.get(this.representative).getName() + "-" + other.subunits.get(other.representative).getName();
        if (afp.getOptLength() < 1) {
            throw new StructureException(String.format("Subunits %s failed to align using %s", pairName, params.getSuperpositionAlgorithm()));
        }
        MultipleAlignment msa = new MultipleAlignmentEnsembleImpl(afp, this.subunits.get(this.representative).getRepresentativeAtoms(), other.subunits.get(other.representative).getRepresentativeAtoms(), false).getMultipleAlignment(0);
        double structureCoverage = Math.min(msa.getCoverages().get(0), msa.getCoverages().get(1));
        if (params.isUseStructureCoverage() && structureCoverage < params.getStructureCoverageThreshold()) {
            return false;
        }
        double rmsd = afp.getTotalRmsdOpt();
        if (params.isUseRMSD() && rmsd > params.getRMSDThreshold()) {
            return false;
        }
        double tmScore = afp.getTMScore();
        if (params.isUseTMScore() && tmScore < params.getTMThreshold()) {
            return false;
        }
        logger.info("SubunitClusters {} are structurally similar with [ {} ] RMSD and [ {} ] coverage", new Object[]{pairName, String.format("%.2f", rmsd), String.format("%.2f", structureCoverage)});
        List<List<Integer>> alignedRes = msa.getBlock(0).getAlignRes();
        ArrayList<Integer> thisAligned = new ArrayList<Integer>();
        ArrayList<Integer> otherAligned = new ArrayList<Integer>();
        for (int p = 0; p < msa.length(); ++p) {
            if (alignedRes.get(0).get(p) == null || alignedRes.get(1).get(p) == null) continue;
            int thisIndex = alignedRes.get(0).get(p);
            int otherIndex = alignedRes.get(1).get(p);
            if (!this.subunitEQR.get(this.representative).contains(thisIndex) || !other.subunitEQR.get(other.representative).contains(otherIndex)) continue;
            thisAligned.add(thisIndex);
            otherAligned.add(otherIndex);
        }
        if (thisAligned.isEmpty() && otherAligned.isEmpty()) {
            logger.warn("No equivalent aligned atoms found between SubunitClusters {} via structure alignment. Will not merge the second one into the first.", (Object)pairName);
            return false;
        }
        this.updateEquivResidues(other, thisAligned, otherAligned);
        this.method = SubunitClustererMethod.STRUCTURE;
        this.pseudoStoichiometric = true;
        return true;
    }

    private void updateEquivResidues(SubunitCluster other, List<Integer> thisAligned, List<Integer> otherAligned) {
        int column;
        int t;
        ArrayList<Integer> thisRemove = new ArrayList<Integer>();
        ArrayList<Integer> otherRemove = new ArrayList<Integer>();
        for (t = 0; t < this.subunitEQR.get(this.representative).size(); ++t) {
            if (thisAligned.contains(this.subunitEQR.get(this.representative).get(t))) continue;
            thisRemove.add(t);
        }
        for (t = 0; t < other.subunitEQR.get(other.representative).size(); ++t) {
            if (otherAligned.contains(other.subunitEQR.get(other.representative).get(t))) continue;
            otherRemove.add(t);
        }
        Collections.sort(thisRemove);
        Collections.reverse(thisRemove);
        Collections.sort(otherRemove);
        Collections.reverse(otherRemove);
        Iterator iterator = thisRemove.iterator();
        while (iterator.hasNext()) {
            column = (Integer)iterator.next();
            this.subunitEQR.forEach(eqr -> eqr.remove(column));
        }
        iterator = otherRemove.iterator();
        while (iterator.hasNext()) {
            column = (Integer)iterator.next();
            other.subunitEQR.forEach(eqr -> eqr.remove(column));
        }
        if (this.subunits.get(this.representative).size() < other.subunits.get(other.representative).size()) {
            this.representative = other.representative + this.subunits.size();
        }
        this.subunits.addAll(other.subunits);
        this.subunitEQR.addAll(other.subunitEQR);
    }

    public boolean divideInternally(SubunitClustererParameters clusterParams) throws StructureException {
        int s;
        CESymmParameters cesym_params = new CESymmParameters();
        cesym_params.setMinCoreLength(clusterParams.getMinimumSequenceLength());
        cesym_params.setGaps(false);
        CeSymmResult result = CeSymm.analyze(this.subunits.get(this.representative).getRepresentativeAtoms(), cesym_params);
        if (!result.isSignificant()) {
            return false;
        }
        double rmsd = result.getMultipleAlignment().getScore("RMSD");
        if (rmsd > clusterParams.getRMSDThreshold()) {
            return false;
        }
        double coverage = result.getMultipleAlignment().getCoverages().get(0) * (double)result.getNumRepeats();
        if (coverage < clusterParams.getStructureCoverageThreshold()) {
            return false;
        }
        logger.info("SubunitCluster is internally symmetric with {} repeats, {} RMSD and {} coverage", new Object[]{result.getNumRepeats(), rmsd, coverage});
        List<List<Integer>> alignedRes = result.getMultipleAlignment().getBlock(0).getAlignRes();
        ArrayList columns = new ArrayList();
        for (int s2 = 0; s2 < alignedRes.size(); ++s2) {
            columns.add(new ArrayList(alignedRes.get(s2).size()));
        }
        for (int col = 0; col < alignedRes.get(0).size(); ++col) {
            boolean missing = false;
            for (s = 0; s < alignedRes.size(); ++s) {
                if (this.subunitEQR.get(this.representative).contains(alignedRes.get(s).get(col))) continue;
                missing = true;
                break;
            }
            if (missing) continue;
            for (s = 0; s < alignedRes.size(); ++s) {
                ((List)columns.get(s)).add(this.subunitEQR.get(this.representative).indexOf(alignedRes.get(s).get(col)));
            }
        }
        ArrayList<Subunit> newSubunits = new ArrayList<Subunit>(this.subunits.size() * columns.size());
        ArrayList<List<Integer>> newSubunitEQR = new ArrayList<List<Integer>>(this.subunits.size() * columns.size());
        for (s = 0; s < this.subunits.size(); ++s) {
            for (int r = 0; r < columns.size(); ++r) {
                int start = this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(0));
                int end = this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(((List)columns.get(r)).size() - 1));
                Atom[] reprAtoms = Arrays.copyOfRange(this.subunits.get(s).getRepresentativeAtoms(), start, end + 1);
                newSubunits.add(new Subunit(reprAtoms, this.subunits.get(s).getName(), this.subunits.get(s).getIdentifier(), this.subunits.get(s).getStructure()));
                ArrayList<Integer> eqr = new ArrayList<Integer>();
                for (int p = 0; p < ((List)columns.get(r)).size(); ++p) {
                    eqr.add(this.subunitEQR.get(s).get((Integer)((List)columns.get(r)).get(p)) - start);
                }
                newSubunitEQR.add(eqr);
            }
        }
        this.subunits = newSubunits;
        this.subunitEQR = newSubunitEQR;
        for (s = 0; s < this.subunits.size(); ++s) {
            if (this.subunits.get(s).size() <= this.subunits.get(this.representative).size()) continue;
            this.representative = s;
        }
        this.method = SubunitClustererMethod.STRUCTURE;
        this.pseudoStoichiometric = true;
        return true;
    }

    public int size() {
        return this.subunits.size();
    }

    public int length() {
        return this.subunitEQR.get(this.representative).size();
    }

    public SubunitClustererMethod getClustererMethod() {
        return this.method;
    }

    public List<Atom[]> getAlignedAtomsSubunits() {
        ArrayList<Atom[]> alignedAtoms = new ArrayList<Atom[]>();
        for (int s = 0; s < this.subunits.size(); ++s) {
            alignedAtoms.add(this.getAlignedAtomsSubunit(s));
        }
        return alignedAtoms;
    }

    public Atom[] getAlignedAtomsSubunit(int index) {
        Atom[] aligned = new Atom[this.subunitEQR.get(index).size()];
        for (int p = 0; p < this.subunitEQR.get(index).size(); ++p) {
            aligned[p] = this.subunits.get(index).getRepresentativeAtoms()[this.subunitEQR.get(index).get(p)];
        }
        return aligned;
    }

    public MultipleAlignment getMultipleAlignment() throws StructureException {
        MultipleAlignmentImpl msa = new MultipleAlignmentImpl();
        msa.setEnsemble(new MultipleAlignmentEnsembleImpl());
        msa.getEnsemble().setAtomArrays(this.subunits.stream().map(s -> s.getRepresentativeAtoms()).collect(Collectors.toList()));
        BlockSetImpl bs = new BlockSetImpl(msa);
        BlockImpl b = new BlockImpl(bs);
        b.setAlignRes(this.subunitEQR);
        new ReferenceSuperimposer(this.representative).superimpose(msa);
        MultipleAlignmentScorer.calculateScores(msa);
        return msa;
    }

    public String toString() {
        return "SubunitCluster [Size=" + this.size() + ", Length=" + this.length() + ", Representative=" + this.representative + ", Method=" + String.valueOf((Object)this.method) + "]";
    }

    public boolean isPseudoStoichiometric() {
        return this.pseudoStoichiometric;
    }
}

