/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.ws.hmmer;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.biojava.nbio.core.sequence.ProteinSequence;
import org.biojava.nbio.ws.hmmer.HmmerDomain;
import org.biojava.nbio.ws.hmmer.HmmerResult;
import org.biojava.nbio.ws.hmmer.HmmerScan;

public class RemoteHmmerScan
implements HmmerScan {
    public static String HMMER_SERVICE = "http://www.ebi.ac.uk/Tools/hmmer/search/hmmscan";

    @Override
    public SortedSet<HmmerResult> scan(ProteinSequence sequence) throws IOException {
        URL url = new URL(HMMER_SERVICE);
        return this.scan(sequence, url);
    }

    public SortedSet<HmmerResult> scan(ProteinSequence sequence, URL serviceLocation) throws IOException {
        String inputLine;
        StringBuffer postContent = new StringBuffer();
        postContent.append("hmmdb=pfam");
        postContent.append("&seq=");
        postContent.append(sequence.getSequenceAsString());
        HttpURLConnection connection = (HttpURLConnection)serviceLocation.openConnection();
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setConnectTimeout(15000);
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty("Accept:", "application/json");
        connection.setRequestProperty("Content-Length", "" + Integer.toString(postContent.toString().getBytes().length));
        DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
        wr.write(postContent.toString().getBytes());
        wr.flush();
        wr.close();
        URL respUrl = new URL(connection.getHeaderField("Location"));
        int responseCode = connection.getResponseCode();
        if (responseCode == 500) {
            System.err.println("something went wrong!" + serviceLocation);
            System.err.println(connection.getResponseMessage());
        }
        HttpURLConnection connection2 = (HttpURLConnection)respUrl.openConnection();
        connection2.setRequestMethod("GET");
        connection2.setRequestProperty("Accept", "application/json");
        connection2.setConnectTimeout(60000);
        BufferedReader in = new BufferedReader(new InputStreamReader(connection2.getInputStream()));
        StringBuffer result = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            result.append(inputLine);
        }
        in.close();
        TreeSet<HmmerResult> results = new TreeSet<HmmerResult>();
        try {
            JSONObject json = JSONObject.fromObject((Object)result.toString());
            JSONObject hmresults = json.getJSONObject("results");
            JSONArray hits = hmresults.getJSONArray("hits");
            for (int i = 0; i < hits.size(); ++i) {
                JSONObject hit = hits.getJSONObject(i);
                HmmerResult hmmResult = new HmmerResult();
                Object dclO = hit.get("dcl");
                Integer dcl = -1;
                if (dclO instanceof Long) {
                    Long dclL = (Long)dclO;
                    dcl = dclL.intValue();
                } else if (dclO instanceof Integer) {
                    dcl = (Integer)dclO;
                }
                hmmResult.setAcc((String)hit.get("acc"));
                hmmResult.setDcl(dcl);
                hmmResult.setDesc((String)hit.get("desc"));
                hmmResult.setEvalue(Float.valueOf(Float.parseFloat((String)hit.get("evalue"))));
                hmmResult.setName((String)hit.get("name"));
                hmmResult.setNdom((Integer)hit.get("ndom"));
                hmmResult.setNreported((Integer)hit.get("nreported"));
                hmmResult.setPvalue((Double)hit.get("pvalue"));
                hmmResult.setScore(Float.valueOf(Float.parseFloat((String)hit.get("score"))));
                JSONArray hmmdomains = hit.getJSONArray("domains");
                TreeSet<HmmerDomain> domains = new TreeSet<HmmerDomain>();
                for (int j = 0; j < hmmdomains.size(); ++j) {
                    Integer significant;
                    Integer outcompeted;
                    JSONObject d = hmmdomains.getJSONObject(j);
                    Integer is_included = this.getInteger(d.get("is_included"));
                    if (is_included == 0 || (outcompeted = this.getInteger(d.get("outcompeted"))) != null && outcompeted == 1 || (significant = this.getInteger(d.get("significant"))) != 1) continue;
                    HmmerDomain dom = new HmmerDomain();
                    dom.setAliLenth((Integer)d.get("aliL"));
                    dom.setHmmAcc((String)d.get("alihmmacc"));
                    dom.setHmmDesc((String)d.get("alihmmdesc"));
                    dom.setHmmFrom(this.getInteger(d.get("alihmmfrom")));
                    dom.setHmmTo(this.getInteger(d.get("alihmmto")));
                    dom.setSimCount((Integer)d.get("aliSimCount"));
                    dom.setSqFrom(this.getInteger(d.get("alisqfrom")));
                    dom.setSqTo(this.getInteger(d.get("alisqto")));
                    dom.setHmmName((String)d.get("alihmmname"));
                    dom.setEvalue(Float.valueOf(Float.parseFloat((String)d.get("ievalue"))));
                    domains.add(dom);
                }
                hmmResult.setDomains(domains);
                results.add(hmmResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private Integer getInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return null;
    }
}

