/*
 * Decompiled with CFR 0.152.
 */
package org.biojava3.core.sequence.loader;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava3.core.exceptions.CompoundNotFoundError;
import org.biojava3.core.exceptions.FileAccessError;
import org.biojava3.core.sequence.AccessionID;
import org.biojava3.core.sequence.Strand;
import org.biojava3.core.sequence.io.template.SequenceParserInterface;
import org.biojava3.core.sequence.storage.SequenceAsStringHelper;
import org.biojava3.core.sequence.template.Compound;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.ProxySequenceReader;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.template.SequenceMixin;
import org.biojava3.core.sequence.template.SequenceProxyView;
import org.biojava3.core.sequence.template.SequenceView;

public class SequenceFileProxyLoader<C extends Compound>
implements ProxySequenceReader<C> {
    SequenceParserInterface sequenceParser;
    private CompoundSet<C> compoundSet;
    private List<C> parsedCompounds = new ArrayList<C>();
    File file;
    long sequenceStartIndex = -1L;
    int sequenceLength = -1;
    private boolean initialized = false;

    public SequenceFileProxyLoader(File file, SequenceParserInterface sequenceParser, long sequenceStartIndex, int sequenceLength, CompoundSet<C> compoundSet) {
        this.sequenceParser = sequenceParser;
        this.file = file;
        this.sequenceStartIndex = sequenceStartIndex;
        this.sequenceLength = sequenceLength;
        this.setCompoundSet(compoundSet);
    }

    @Override
    public void setCompoundSet(CompoundSet<C> compoundSet) {
        this.compoundSet = compoundSet;
    }

    private boolean init() {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "r");
            randomAccessFile.seek(this.sequenceStartIndex);
            String sequence = this.sequenceParser.getSequence(randomAccessFile, this.sequenceLength);
            this.setContents(sequence);
        }
        catch (Exception e) {
            throw new FileAccessError("Error accessing " + this.file + " offset=" + this.sequenceStartIndex + " sequenceLength=" + this.sequenceLength + " " + e.toString());
        }
        return true;
    }

    @Override
    public void setContents(String sequence) {
        String compoundStr;
        this.parsedCompounds.clear();
        for (int i = 0; i < sequence.length(); i += compoundStr.length()) {
            compoundStr = null;
            Object compound = null;
            for (int compoundStrLength = 1; compound == null && compoundStrLength <= this.compoundSet.getMaxSingleCompoundStringLength(); ++compoundStrLength) {
                compoundStr = sequence.substring(i, i + compoundStrLength);
                compound = this.compoundSet.getCompoundForString(compoundStr);
            }
            if (compound == null) {
                throw new CompoundNotFoundError((CharSequence)compoundStr);
            }
            this.parsedCompounds.add(compound);
        }
        this.setInitialized(true);
    }

    @Override
    public int getLength() {
        return this.sequenceLength;
    }

    @Override
    public C getCompoundAt(int position) {
        if (!this.isInitialized()) {
            this.init();
        }
        return (C)((Compound)this.parsedCompounds.get(position - 1));
    }

    @Override
    public int getIndexOf(C compound) {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.parsedCompounds.indexOf(compound) + 1;
    }

    @Override
    public int getLastIndexOf(C compound) {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.parsedCompounds.lastIndexOf(compound) + 1;
    }

    public String toString() {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.getSequenceAsString();
    }

    @Override
    public String getSequenceAsString() {
        return this.getSequenceAsString(1, this.getLength(), Strand.POSITIVE);
    }

    public String getSequenceAsString(Integer bioBegin, Integer bioEnd, Strand strand) {
        if (!this.isInitialized()) {
            this.init();
        }
        SequenceAsStringHelper<C> sequenceAsStringHelper = new SequenceAsStringHelper<C>();
        return sequenceAsStringHelper.getSequenceAsString(this.parsedCompounds, this.compoundSet, bioBegin, bioEnd, strand);
    }

    @Override
    public List<C> getAsList() {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.parsedCompounds;
    }

    @Override
    public SequenceView<C> getSubSequence(Integer bioBegin, Integer bioEnd) {
        if (!this.isInitialized()) {
            this.init();
        }
        return new SequenceProxyView(this, bioBegin, bioEnd);
    }

    @Override
    public Iterator<C> iterator() {
        if (!this.isInitialized()) {
            this.init();
        }
        return this.parsedCompounds.iterator();
    }

    @Override
    public CompoundSet<C> getCompoundSet() {
        return this.compoundSet;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    @Override
    public AccessionID getAccession() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int countCompounds(C ... compounds) {
        return SequenceMixin.countCompounds((Sequence)this, compounds);
    }

    @Override
    public SequenceView<C> getInverse() {
        return SequenceMixin.inverse(this);
    }
}

