/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import org.biojava.utils.bytecode.ByteCode;
import org.biojava.utils.bytecode.CodeContext;
import org.biojava.utils.bytecode.CodeException;
import org.biojava.utils.bytecode.CodeGenerator;
import org.biojava.utils.bytecode.Instruction;
import org.biojava.utils.bytecode.InstructionVector;
import org.biojava.utils.bytecode.Label;

public class IfExpression
implements CodeGenerator {
    private Instruction ifInstruction;
    private CodeGenerator ifTrue;
    private CodeGenerator ifFalse;
    private Label trueLabel = new Label();
    private Label endLabel = new Label();
    private Instruction skipTrue = ByteCode.make_goto(this.endLabel);
    private InstructionVector instructions;

    public IfExpression(byte ifInstruction, CodeGenerator ifTrue, CodeGenerator ifFalse) {
        this.ifInstruction = ByteCode.make_if(ifInstruction, this.trueLabel);
        this.ifTrue = ifTrue;
        this.ifFalse = ifFalse;
        this.instructions = new InstructionVector();
        this.instructions.add(this.ifInstruction);
        this.instructions.add(this.ifFalse);
        this.instructions.add(this.skipTrue);
        this.instructions.add(ByteCode.make_markLabel(this.trueLabel));
        this.instructions.add(this.ifTrue);
        this.instructions.add(ByteCode.make_markLabel(this.endLabel));
    }

    public Instruction getIfInstruction() {
        return this.ifInstruction;
    }

    public CodeGenerator getIfTrue() {
        return this.ifTrue;
    }

    public CodeGenerator getIfFalse() {
        return this.ifFalse;
    }

    @Override
    public void writeCode(CodeContext ctx) throws CodeException {
        this.instructions.writeCode(ctx);
    }

    @Override
    public int stackDepth() {
        return this.ifInstruction.stackDepth() + Math.max(this.ifFalse.stackDepth(), this.ifTrue.stackDepth());
    }

    @Override
    public int stackDelta() {
        return this.ifInstruction.stackDepth() + Math.max(this.ifFalse.stackDepth(), this.ifTrue.stackDepth());
    }
}

