/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import java.util.HashMap;

public class TSType
extends HashMap<String, Object> {
    protected TSType() {
        super(3);
    }

    public static TSType from(final Class<?> cl, final boolean export) {
        return new TSType(){
            {
                this.put("value", cl);
                this.put("export", export);
            }
        };
    }

    public static TSType from(final Class<?> cl, final String alias, final boolean export) {
        return new TSType(){
            {
                this.put("value", cl);
                this.put("export", export);
                this.put("alias", alias);
            }
        };
    }

    public static TSType functional(final Class<?> cl, final String alias) {
        return new TSType(){
            {
                this.put("value", cl);
                this.put("alias", alias);
                this.put("functional", true);
            }
        };
    }

    protected static TSType from(final Class<?> cl) {
        return new TSType(){
            {
                this.put("value", cl);
            }
        };
    }

    public Class<?> getValue() {
        return this.getClassFrom(super.get("value"));
    }

    public boolean isExport() {
        return super.getOrDefault("export", false);
    }

    public TSType setExport(boolean export) {
        super.put("export", export);
        return this;
    }

    public boolean isFunctionalInterface() {
        return super.getOrDefault("functional", false) != false || this.getValue().isInterface() && this.getValue().isAnnotationPresent(FunctionalInterface.class);
    }

    public boolean hasAlias() {
        String alias = (String)super.get("alias");
        return alias != null && !alias.isEmpty();
    }

    public String getAlias() {
        return (String)super.get("alias");
    }

    public final String getTypeName() {
        return this.hasAlias() ? this.getAlias() : this.getValue().getName();
    }

    public final String getSimpleTypeName() {
        return this.hasAlias() ? this.getAlias() : this.getValue().getSimpleName();
    }

    private Class<?> getClassFrom(Object dt) {
        if (dt instanceof Class) {
            return (Class)dt;
        }
        try {
            return Class.forName(dt.toString());
        }
        catch (ClassNotFoundException e1) {
            throw new RuntimeException(String.format("class not found [%s]", dt), e1);
        }
    }

    @Override
    public boolean equals(Object o) {
        return this.getValue().equals(((TSType)o).getValue());
    }

    @Override
    public int hashCode() {
        return this.getValue().hashCode();
    }
}

