/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bsc.processor.TSType;

public class TypescriptHelper {
    public static BiPredicate<Class<?>, Class<?>> isPackageMatch = (a, b) -> a.getPackage().equals(b.getPackage());
    private static BiFunction<Class<?>, Type, Boolean> typeParameterMatch = (declaringClass, type) -> type instanceof TypeVariable ? Arrays.stream(declaringClass.getTypeParameters()).map(tp -> tp.getName()).anyMatch(name -> name.equals(((TypeVariable)type).getName())) : false;

    private static final void log(String fmt, Object ... args) {
    }

    private static final void debug(String fmt, Object ... args) {
        System.out.print("DEBUG: ");
        System.out.println(String.format(fmt, args));
    }

    public static final String processFunctionalInterface(TSType type) {
        Objects.requireNonNull(type, "argument 'type' is not defined!");
        return null;
    }

    public static final String getAliasDeclaration(Class<?> type, String alias) {
        Objects.requireNonNull(type, "argument 'type' is not defined!");
        Objects.requireNonNull(alias, "argument 'alias' is not defined!");
        TypeVariable<Class<?>>[] typeParameters = type.getTypeParameters();
        if (typeParameters != null && typeParameters.length > 0) {
            String pp = Arrays.stream(typeParameters).map(tp -> tp.getName()).collect(Collectors.joining(",", "<", ">"));
            return String.format("type %s%s = %s%s;\n\n", alias, pp, type.getName(), pp);
        }
        return String.format("type %s = %s;\n\n", alias, type.getName());
    }

    public static final String getParameterName(Parameter p) {
        String name;
        switch (name = p.getName()) {
            case "function": {
                return "func";
            }
        }
        return name;
    }

    static <M extends Member> boolean isStatic(M m) {
        int modifier = m.getModifiers();
        return Modifier.isStatic(modifier) && Modifier.isPublic(modifier);
    }

    static boolean isFactoryMethod(Method m) {
        return TypescriptHelper.isStatic(m) && m.getReturnType().equals(m.getDeclaringClass());
    }

    static StringBuilder getClassDecl(StringBuilder statement, TSType tstype, Map<String, TSType> declaredClassMap) {
        StringBuilder inherited = new StringBuilder();
        if (tstype.getValue().isInterface()) {
            statement.append("interface ");
        } else {
            if (tstype.getValue().isEnum()) {
                statement.append("/* enum */");
            }
            statement.append("class ");
            TSType superclass = TSType.from(tstype.getValue().getSuperclass());
            if (superclass != null) {
                inherited.append(" extends ").append(TypescriptHelper.getTypeName(superclass, tstype, true));
            }
        }
        Class<?>[] interfaces = tstype.getValue().getInterfaces();
        if (interfaces.length > 0) {
            String ifc = Arrays.stream(interfaces).map(c -> TSType.from(c)).map(t -> TypescriptHelper.getTypeName(t, tstype, true)).collect(Collectors.joining(", "));
            inherited.append(tstype.getValue().isInterface() ? " extends " : " implements ").append(ifc);
        }
        statement.append(TypescriptHelper.getTypeName(tstype, tstype, true));
        if (inherited.length() > 0) {
            statement.append("/*").append((CharSequence)inherited).append("*/");
        }
        return statement.append(" {");
    }

    static String getClassParametersDecl(List<String> type_parameters_list) {
        if (type_parameters_list.isEmpty()) {
            return "";
        }
        return String.format("<%s>", type_parameters_list.stream().collect(Collectors.joining(", ")));
    }

    static String getTypeName(TSType type, TSType declaringType, boolean packageResolution) {
        List<String> dc_parameters_list = Arrays.stream(declaringType.getValue().getTypeParameters()).map(tp -> tp.getName()).collect(Collectors.toList());
        List type_parameters_list = Arrays.stream(type.getValue().getTypeParameters()).map(tp -> dc_parameters_list.contains(tp.getName()) ? tp.getName() : "any").collect(Collectors.toList());
        List<String> parameters = dc_parameters_list.size() == type_parameters_list.size() ? dc_parameters_list : type_parameters_list;
        Package currentNS = packageResolution ? declaringType.getValue().getPackage() : null;
        return (type.getValue().getPackage().equals(currentNS) || type.isFunctionalInterface() ? type.getSimpleTypeName() : type.getTypeName()) + TypescriptHelper.getClassParametersDecl(parameters);
    }

    public static <M extends Member> String convertJavaToTS(Type type, M declaringMember, TSType declaringType, Map<String, TSType> declaredTypeMap, boolean packageResolution, Optional<Consumer<TypeVariable<?>>> onTypeMismatch) {
        Objects.requireNonNull(type, "Type argument is null!");
        Objects.requireNonNull(declaringMember, "declaringMethod argument is null!");
        Objects.requireNonNull(declaringType, "declaringType argument is null!");
        Objects.requireNonNull(declaredTypeMap, "declaredTypeMap argument is null!");
        Predicate<TypeVariable> typeMismatch = tv -> {
            if (TypescriptHelper.isStatic(declaringMember)) {
                return true;
            }
            if (declaringMember instanceof Constructor) {
                return true;
            }
            return typeParameterMatch.apply(declaringType.getValue(), (Type)tv) == false;
        };
        if (type instanceof ParameterizedType) {
            Type[] typeArgs;
            ParameterizedType pType = (ParameterizedType)type;
            Class rawType = (Class)pType.getRawType();
            TSType tstype = declaredTypeMap.get(rawType.getName());
            if (tstype == null) {
                return String.format("any /*%s*/", rawType.getName());
            }
            String result = pType.getTypeName().replace(rawType.getName(), tstype.getTypeName());
            if (tstype.isFunctionalInterface() || packageResolution && isPackageMatch.test(tstype.getValue(), declaringType.getValue())) {
                result = result.replace(tstype.getTypeName(), tstype.getSimpleTypeName());
            }
            for (Type t : typeArgs = pType.getActualTypeArguments()) {
                if (t instanceof ParameterizedType) {
                    String typeName = TypescriptHelper.convertJavaToTS(t, declaringMember, declaringType, declaredTypeMap, packageResolution, onTypeMismatch);
                    TypescriptHelper.log("Parameterized Type %s - %s", t, typeName);
                    result = result.replace(t.getTypeName(), typeName);
                    continue;
                }
                if (t instanceof TypeVariable) {
                    TypescriptHelper.log("type variable: %s", t);
                    TypeVariable tv2 = (TypeVariable)t;
                    if (!typeMismatch.test(tv2)) continue;
                    if (onTypeMismatch.isPresent()) {
                        onTypeMismatch.get().accept(tv2);
                        continue;
                    }
                    String name = tv2.getName();
                    result = result.replaceAll("<" + name, "<any").replaceAll(",\\s" + name, ", any").replaceAll(name + ">", "any>");
                    continue;
                }
                if (t instanceof Class) {
                    TypescriptHelper.log("class: %s", t.getTypeName());
                    String name = TypescriptHelper.convertJavaToTS((Class)t, declaringType, declaredTypeMap, packageResolution);
                    String commented = String.format("/*%s*/", t.getTypeName());
                    result = result.replace(commented, "/*@*/").replace(t.getTypeName(), name).replace("/*@*/", commented);
                    continue;
                }
                if (t instanceof WildcardType) {
                    WildcardType wt = (WildcardType)t;
                    Type[] lb = wt.getLowerBounds();
                    Type[] ub = wt.getUpperBounds();
                    TypescriptHelper.log("Wildcard Type : %s lb:%d up:%d", type.getTypeName(), lb.length, ub.length);
                    if (lb.length <= 1 && ub.length == 1) {
                        Type tt = lb.length == 1 ? lb[0] : ub[0];
                        String s = TypescriptHelper.convertJavaToTS(tt, declaringMember, declaringType, declaredTypeMap, packageResolution, onTypeMismatch);
                        result = result.replace(wt.getTypeName(), s);
                        if (!(tt instanceof ParameterizedType) || !Stream.of(((ParameterizedType)tt).getActualTypeArguments()).anyMatch(arg -> arg instanceof WildcardType)) continue;
                        Class clazz = (Class)((ParameterizedType)tt).getRawType();
                        String typeName = wt.getTypeName().replace(clazz.getName(), clazz.getSimpleName());
                        result = result.replace(typeName, s);
                        continue;
                    }
                    result = result.replace(wt.getTypeName(), String.format("any/*%s*/", wt));
                    continue;
                }
                if (!(t instanceof GenericArrayType)) continue;
                throw new IllegalArgumentException(String.format("type argument <%s> 'GenericArrayType' is a  not supported yet!", t));
            }
            return result;
        }
        if (type instanceof TypeVariable) {
            TypescriptHelper.log("class: %s", type.getTypeName());
            TypeVariable tv3 = (TypeVariable)type;
            if (typeMismatch.test(tv3)) {
                String name = tv3.getName();
                if (onTypeMismatch.isPresent()) {
                    onTypeMismatch.get().accept(tv3);
                    return name;
                }
                return String.format("any/*%s*/", name);
            }
            return type.getTypeName();
        }
        if (type instanceof Class) {
            TypescriptHelper.log("class: %s", type.getTypeName());
            String name = TypescriptHelper.convertJavaToTS((Class)type, declaringType, declaredTypeMap, packageResolution);
            return name;
        }
        if (type instanceof WildcardType) {
            throw new IllegalArgumentException("type 'WildcardType' is a  not supported yet!");
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType t = (GenericArrayType)type;
            Type componentType = t.getGenericComponentType();
            TypescriptHelper.log("generic array type: %s", componentType.getTypeName());
            String tt = TypescriptHelper.convertJavaToTS(componentType, declaringMember, declaringType, declaredTypeMap, packageResolution, onTypeMismatch);
            return String.format("[%s]", tt);
        }
        throw new IllegalArgumentException("type is a  not recognised type!");
    }

    private static String convertJavaToTS(Class<?> type, TSType declaringType, Map<String, TSType> declaredTypeMap, boolean packageResolution) {
        if (type == null) {
            return "any";
        }
        if (Void.class.isAssignableFrom(type) || type.equals(Void.TYPE)) {
            return "void";
        }
        if (Boolean.class.isAssignableFrom(type) || type.equals(Boolean.TYPE)) {
            return type.isPrimitive() ? "boolean" : "boolean|null";
        }
        if (Integer.class.isAssignableFrom(type) || type.equals(Integer.TYPE)) {
            return type.isPrimitive() ? "int" : "int|null";
        }
        if (Long.class.isAssignableFrom(type) || type.equals(Long.TYPE)) {
            return type.isPrimitive() ? "long" : "long|null";
        }
        if (Float.class.isAssignableFrom(type) || type.equals(Float.TYPE)) {
            return type.isPrimitive() ? "float" : "float|null";
        }
        if (Double.class.isAssignableFrom(type) || type.equals(Double.TYPE)) {
            return type.isPrimitive() ? "double" : "double|null";
        }
        if (Integer.class.isAssignableFrom(type) || type.equals(Integer.TYPE)) {
            return type.isPrimitive() ? "int" : "int|null";
        }
        if (String.class.isAssignableFrom(type)) {
            return "string";
        }
        if (char[].class.equals(type)) {
            return "chararray";
        }
        if (byte[].class.equals(type)) {
            return "bytearray";
        }
        if (type.isArray()) {
            return String.format("[%s]", TypescriptHelper.convertJavaToTS(type.getComponentType(), declaringType, declaredTypeMap, packageResolution));
        }
        TSType tt = declaredTypeMap.get(type.getName());
        if (tt != null) {
            return TypescriptHelper.getTypeName(tt, declaringType, packageResolution);
        }
        return String.format("any /*%s*/", type.getName());
    }
}

