/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import org.bsc.processor.AbstractProcessorEx;
import org.bsc.processor.TSType;
import org.bsc.processor.TypescriptHelper;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.bsc.processor.*"})
@SupportedOptions(value={"ts.outfile"})
public class TypescriptProcessor
extends AbstractProcessorEx {
    static final String ENDL = ";\n";
    static final List<TSType> PREDEFINED_TYPES = Arrays.asList(TSType.from(Class.class), TSType.from(Serializable.class), TSType.from(Closeable.class), TSType.from(AutoCloseable.class), TSType.from(Comparable.class), TSType.from(Cloneable.class), TSType.from(RandomAccess.class), TSType.from(Function.class, "Func", false), TSType.from(BiFunction.class, "BiFunc", false), TSType.from(Consumer.class), TSType.from(BiConsumer.class), TSType.from(UnaryOperator.class), TSType.from(BinaryOperator.class), TSType.from(Supplier.class), TSType.from(Predicate.class), TSType.from(BiPredicate.class), TSType.from(Runnable.class));
    static final List<TSType> REQUIRED_TYPES = Arrays.asList(TSType.from(String.class, true), TSType.from(Iterable.class, true), TSType.from(Iterator.class, true), TSType.from(Collection.class), TSType.from(Collections.class, true), TSType.from(List.class), TSType.from(Set.class), TSType.from(Map.class), TSType.from(Stream.class, true), TSType.from(Collectors.class, true), TSType.from(Optional.class, true));

    private Writer openFile(Path file, String header) throws IOException {
        FileObject out = super.getSourceOutputFile(Paths.get("ts", new String[0]), file);
        this.info("output file [%s]", out.getName());
        Writer w = out.openWriter();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(header);){
            int c;
            while ((c = is.read()) != -1) {
                w.write(c);
            }
        }
        return w;
    }

    @Override
    public boolean process(AbstractProcessorEx.Context processingContext) throws Exception {
        String targetDefinitionFile = processingContext.getOptionMap().getOrDefault("ts.outfile", "out");
        String definitionsFile = targetDefinitionFile.concat(".d.ts");
        String typesFile = targetDefinitionFile.concat("-types.ts");
        try (Writer wD = this.openFile(Paths.get(definitionsFile, new String[0]), "headerD.ts");
             Writer wT = this.openFile(Paths.get(typesFile, new String[0]), "headerT.ts");){
            Consumer<String> wD_append = s -> {
                try {
                    wD.append((CharSequence)s);
                }
                catch (IOException e) {
                    this.error("error adding [%s]", s);
                }
            };
            Consumer<String> wT_append = s -> {
                try {
                    wT.append((CharSequence)s);
                }
                catch (IOException e) {
                    this.error("error adding [%s]", s);
                }
            };
            Set<TSType> types = this.enumerateDeclaredPackageAndClass(processingContext);
            types.addAll(REQUIRED_TYPES);
            wD.append("//\n").append("// TYPE ALIASES\n").append("//\n\n");
            types.stream().filter(t -> !t.isFunctionalInterface()).filter(t -> t.hasAlias()).map(t -> TypescriptHelper.getAliasDeclaration(t.getValue(), t.getAlias())).forEach(wD_append);
            types.addAll(PREDEFINED_TYPES);
            Map<String, TSType> declaredTypes = types.stream().collect(Collectors.toMap(tt -> tt.getValue().getName(), tt -> tt));
            types.stream().filter(tt -> !PREDEFINED_TYPES.contains(tt)).map(tt -> this.processClass((TSType)tt, declaredTypes)).forEach(wD_append);
            wT.append("/// <reference path=\"").append(definitionsFile).append("\"/>").append("\n\n");
            types.stream().filter(t -> t.isExport()).map(t -> this.processStatic((TSType)t, declaredTypes)).forEach(wT_append);
        }
        return true;
    }

    protected <E extends Executable> String getMethodParametersAndReturnDecl(E m, TSType declaringType, Map<String, TSType> declaredTypeMap, boolean packageResolution) {
        HashSet TypeVarSet = new HashSet(5);
        Consumer<TypeVariable> addTypeVar = tv -> TypeVarSet.add(tv.getName());
        Parameter[] params = m.getParameters();
        String params_string = Arrays.stream(params).map(tp -> {
            String name = TypescriptHelper.getParameterName(tp);
            if (tp.isVarArgs()) {
                String type = null;
                type = tp.getParameterizedType() instanceof GenericArrayType ? TypescriptHelper.convertJavaToTS(((GenericArrayType)tp.getParameterizedType()).getGenericComponentType(), m, declaringType, declaredTypeMap, packageResolution, Optional.of(addTypeVar)) : TypescriptHelper.convertJavaToTS(tp.getType().getComponentType(), m, declaringType, declaredTypeMap, packageResolution, Optional.of(addTypeVar));
                return String.format("...%s:%s[]", name, type);
            }
            String type = TypescriptHelper.convertJavaToTS(tp.getParameterizedType(), m, declaringType, declaredTypeMap, packageResolution, Optional.of(addTypeVar));
            return String.format("%s:%s", name, type);
        }).collect(Collectors.joining(", "));
        Type returnType = m instanceof Method ? ((Method)m).getGenericReturnType() : declaringType.getValue();
        String tsReturnType = TypescriptHelper.convertJavaToTS(returnType, m, declaringType, declaredTypeMap, packageResolution, Optional.of(addTypeVar));
        StringBuilder result = new StringBuilder();
        if (!TypeVarSet.isEmpty()) {
            result.append('<').append(TypeVarSet.stream().collect(Collectors.joining(","))).append('>');
        }
        return result.append("( ").append(params_string).append(" ):").append(tsReturnType).toString();
    }

    private String getMethodDecl(Method m, TSType declaringClass, Map<String, TSType> declaredClassMap) {
        StringBuilder sb = new StringBuilder();
        if (Modifier.isStatic(m.getModifiers())) {
            if (declaringClass.getValue().isInterface()) {
                sb.append("// ");
            }
            sb.append("static ").append(m.getName());
        } else {
            sb.append(m.getName());
        }
        sb.append(this.getMethodParametersAndReturnDecl(m, declaringClass, declaredClassMap, true));
        return sb.toString();
    }

    private Set<Field> getFields(TSType type) {
        Predicate<Field> std = f -> !f.isSynthetic() && Modifier.isPublic(f.getModifiers()) && Character.isJavaIdentifierStart(f.getName().charAt(0)) && f.getName().chars().skip(1L).allMatch(Character::isJavaIdentifierPart);
        return Stream.concat(Stream.of(type.getValue().getFields()), Stream.of(type.getValue().getDeclaredFields())).filter(std).collect(Collectors.toSet());
    }

    private Set<Method> getMethods(TSType type) {
        Predicate<Method> include = m -> !m.isBridge() && !m.isSynthetic() && Modifier.isPublic(m.getModifiers()) && Character.isJavaIdentifierStart(m.getName().charAt(0)) && m.getName().chars().skip(1L).allMatch(Character::isJavaIdentifierPart);
        return Stream.concat(Stream.of(type.getValue().getMethods()), Stream.of(type.getValue().getDeclaredMethods())).filter(include).collect(Collectors.toSet());
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private void processNestedClasses(StringBuilder sb, TSType tstype, Map<String, TSType> declaredTypeMap) {
        Class<?>[] nestedClasses = tstype.getValue().getClasses();
        if (nestedClasses.length == 0) {
            return;
        }
        sb.append("export module ").append(tstype.getSimpleTypeName()).append(" {\n\n");
        Stream.of(nestedClasses).filter(TypescriptProcessor.distinctByKey(c -> c.getSimpleName())).map(cl -> TSType.from(cl)).map(t -> this.processClass((TSType)t, declaredTypeMap)).forEach(decl -> sb.append((String)decl));
        sb.append("\n} // end module ").append(tstype.getSimpleTypeName()).append('\n');
    }

    private StringBuilder processEnumDecl(StringBuilder sb, TSType type) {
        if (type.getValue().isEnum()) {
            type.setExport(true);
            Arrays.stream(type.getValue().getEnumConstants()).forEach(c -> sb.append('\t').append("// ").append(c.toString()).append(':').append(type.getSimpleTypeName()).append(';').append('\n'));
            sb.append('\n');
        }
        return sb;
    }

    private StringBuilder processEnumType(StringBuilder sb, TSType type) {
        if (type.getValue().isEnum()) {
            Arrays.stream(type.getValue().getEnumConstants()).forEach(c -> sb.append('\t').append(c.toString()).append(':').append(type.getTypeName()).append(';').append('\n'));
            sb.append('\n');
        }
        return sb;
    }

    private String processStatic(TSType type, Map<String, TSType> declaredClassMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("interface ").append(type.getSimpleTypeName()).append("Static {\n\n");
        this.processEnumType(sb, type).append("\treadonly class:any;\n");
        Stream.of(type.getValue().getConstructors()).filter(c -> Modifier.isPublic(c.getModifiers())).forEach(c -> sb.append("\tnew").append(this.getMethodParametersAndReturnDecl(c, type, declaredClassMap, false)).append(ENDL));
        Set methodSet = this.getMethods(type).stream().filter(TypescriptHelper::isStatic).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        if (!methodSet.isEmpty()) {
            methodSet.stream().sorted((a, b) -> a.getName().compareTo(b.getName())).forEach(md -> sb.append('\t').append(md.getName()).append(this.getMethodParametersAndReturnDecl(md, type, declaredClassMap, false)).append(ENDL));
        }
        sb.append("}\n\n").append("export const ").append(type.getSimpleTypeName()).append(": ").append(type.getSimpleTypeName()).append("Static = Java.type(\"").append(type.getValue().getName()).append("\")").append(ENDL).append("\n\n");
        return sb.toString();
    }

    private String processClass(TSType tstype, Map<String, TSType> declaredClassMap) {
        StringBuilder sb = new StringBuilder();
        String namespace = tstype.getValue().getPackage().getName();
        if (!tstype.getValue().isMemberClass()) {
            sb.append("declare namespace ").append(namespace).append(" {\n\n");
        }
        TypescriptHelper.getClassDecl(sb, tstype, declaredClassMap).append("\n\n");
        this.processEnumDecl(sb, tstype);
        Set methodSet = this.getMethods(tstype).stream().filter(md -> !(tstype.isExport() && TypescriptHelper.isStatic(md))).filter(md -> {
            String name = md.getName();
            return !name.contains("$") && !name.equals("getClass") && !name.equals("hashCode") && !name.equals("wait") && !name.equals("notify") && !name.equals("notifyAll");
        }).collect(Collectors.toCollection(() -> new LinkedHashSet()));
        methodSet.stream().map(md -> this.getMethodDecl((Method)md, tstype, declaredClassMap)).sorted().forEach(decl -> sb.append('\t').append((String)decl).append(ENDL));
        sb.append("\n} // end ").append(tstype.getSimpleTypeName()).append('\n');
        this.processNestedClasses(sb, tstype, declaredClassMap);
        if (!tstype.getValue().isMemberClass()) {
            sb.append("\n} // end namespace ").append(namespace).append('\n');
        }
        return sb.toString();
    }

    private List<? extends AnnotationValue> getAnnotationValueValue(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        AnnotationValue av = entry.getValue();
        return (List)av.getValue();
    }

    private Set<TSType> enumerateDeclaredPackageAndClass(AbstractProcessorEx.Context processingContext) {
        return processingContext.elementFromAnnotations(Optional.empty()).stream().peek(e -> this.info("Anotation [%s]", e.getKind().name())).filter(e -> ElementKind.PACKAGE == e.getKind() || ElementKind.CLASS == e.getKind()).flatMap(e -> e.getAnnotationMirrors().stream()).peek(m -> this.info("Mirror [%s]", m.toString())).flatMap(am -> am.getElementValues().entrySet().stream().filter(entry -> "declare".equals(String.valueOf(((ExecutableElement)entry.getKey()).getSimpleName())))).flatMap(entry -> this.getAnnotationValueValue((Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)entry).stream()).map(av -> av.getValue()).filter(v -> v instanceof AnnotationMirror).map(v -> (AnnotationMirror)v).map(am -> this.toMapObject((AnnotationMirror)am, () -> new TSType())).collect(Collectors.toSet());
    }

    @Deprecated
    private StringBuilder appendStaticMethodTypeParameters(StringBuilder sb, Method m) {
        TypeVariable<Class<?>>[] return_type_parameters = m.getReturnType().getTypeParameters();
        if (return_type_parameters.length > 0) {
            String pp = Arrays.asList(return_type_parameters).stream().map(t -> t.getName()).collect(Collectors.joining(",", "<", ">"));
            sb.append(pp);
        }
        return sb;
    }
}

