/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import com.sun.source.util.Trees;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.json.Json;
import javax.json.JsonObjectBuilder;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractProcessorEx
extends AbstractProcessor {
    protected void info(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
    }

    protected void warn(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
    }

    protected void warn(String msg, Throwable t) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, msg);
        t.printStackTrace(System.err);
    }

    protected void error(String fmt, Object ... args) {
        String msg = String.format(fmt, args);
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
    }

    protected void error(String msg, Throwable t) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        t.printStackTrace(System.err);
    }

    protected FileObject getSourceOutputFile(Path subfolder, Path filePath) throws IOException {
        Filer filer = this.processingEnv.getFiler();
        Object e = null;
        FileObject res = filer.createResource(StandardLocation.SOURCE_OUTPUT, subfolder.toString(), filePath.toString(), e);
        return res;
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.info("PROCESSOR START", new Object[0]);
        if (roundEnv.processingOver()) {
            return false;
        }
        Context processinContext = new Context(annotations, roundEnv);
        try {
            return this.process(processinContext);
        }
        catch (Exception ex) {
            this.error("PROCESSING ERROR", ex);
            return false;
        }
    }

    protected <R extends Map<String, Object>> R toMapObject(AnnotationMirror am, Supplier<R> supplier) {
        Collector<Map.Entry, Map, Map> c = Collector.of(supplier, (map, entry) -> {
            Object object = map.put(((ExecutableElement)entry.getKey()).getSimpleName().toString(), ((AnnotationValue)entry.getValue()).getValue());
        }, (v1, v2) -> v1, new Collector.Characteristics[0]);
        Map result = am.getElementValues().entrySet().stream().collect(c);
        return (R)result;
    }

    protected <R> R toJsonObject(AnnotationMirror am, Function<JsonObjectBuilder, R> finisher) {
        Collector<Map.Entry, JsonObjectBuilder, R> c = Collector.of(() -> Json.createObjectBuilder(), (builder, entry) -> {
            String k = ((ExecutableElement)entry.getKey()).getSimpleName().toString();
            Object v = ((AnnotationValue)entry.getValue()).getValue();
            if (v == null) {
                builder.addNull(k);
            } else if (v instanceof Boolean) {
                builder.add(k, ((Boolean)v).booleanValue());
            } else {
                builder.add(k, String.valueOf(v));
            }
        }, (v1, v2) -> v1, finisher, new Collector.Characteristics[0]);
        R result = am.getElementValues().entrySet().stream().collect(c);
        return result;
    }

    public abstract boolean process(Context var1) throws Exception;

    public class Context {
        public final Set<? extends TypeElement> annotations;
        public final RoundEnvironment roundEnv;
        final Map<String, String> optionMap;

        public Context(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            this.annotations = annotations;
            this.roundEnv = roundEnv;
            this.optionMap = Optional.ofNullable(AbstractProcessorEx.this.processingEnv.getOptions()).orElse(Collections.emptyMap());
        }

        public final Trees getTrees() {
            return Trees.instance(AbstractProcessorEx.this.processingEnv);
        }

        public final Map<String, String> getOptionMap() {
            return AbstractProcessorEx.this.processingEnv.getOptions();
        }

        public List<? extends Element> elementFromAnnotations(Optional<Predicate<? super TypeElement>> filter) {
            return this.annotations.stream().filter(filter.orElse(e -> true)).flatMap(e -> this.roundEnv.getElementsAnnotatedWith((TypeElement)e).stream()).collect(Collectors.toList());
        }
    }
}

