/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import org.bsc.java2typescript.TSType;
import org.bsc.java2typescript.TypescriptConverter;
import org.bsc.java2typescript.TypescriptConverterStatic;
import org.bsc.processor.AbstractProcessorEx;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.bsc.processor.*"})
@SupportedOptions(value={"ts.outfile", "compatibility"})
public class TypescriptProcessor
extends AbstractProcessorEx {
    static final String ENDL = ";\n";
    static final List<TSType> REQUIRED_TYPES = Arrays.asList(TSType.from(String.class).setExport(true), TSType.from(Iterable.class).setExport(true).setFunctional(true), TSType.from(Iterator.class), TSType.from(Collection.class), TSType.from(List.class), TSType.from(Set.class), TSType.from(Map.class), TSType.from(Optional.class).setExport(true), TSType.from(Stream.class).setExport(true), TSType.from(Collectors.class).setExport(true), TSType.from(Collections.class).setExport(true), TSType.from(Function.class).setAlias("Func"), TSType.from(BiFunction.class).setAlias("BiFunction"), TSType.from(Consumer.class).setAlias("Consumer"), TSType.from(BiConsumer.class).setAlias("BiConsumer"), TSType.from(UnaryOperator.class).setAlias("UnaryOperator"), TSType.from(BinaryOperator.class).setAlias("BinaryOperator"), TSType.from(Supplier.class).setAlias("Supplier"), TSType.from(Predicate.class).setAlias("Predicate"), TSType.from(BiPredicate.class).setAlias("BiPredicate"), TSType.from(Runnable.class), TSType.from(Comparable.class));

    private Writer openFile(Path file, String header) throws IOException {
        FileObject out = super.getSourceOutputFile(Paths.get("ts", new String[0]), file);
        this.info("output file [%s]", out.getName());
        Writer w = out.openWriter();
        Throwable throwable = null;
        Object var6_7 = null;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(header);){
            int c;
            while ((c = is.read()) != -1) {
                w.write(c);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return w;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(AbstractProcessorEx.Context processingContext) throws Exception {
        String targetDefinitionFile = processingContext.getOptionMap().getOrDefault("ts.outfile", "out");
        String definitionsFile = targetDefinitionFile.concat(".d.ts");
        String typesFile = targetDefinitionFile.concat("-types.ts");
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Writer wD = this.openFile(Paths.get(definitionsFile, new String[0]), "headerD.ts");
            try {
                try (Writer wT = this.openFile(Paths.get(typesFile, new String[0]), "headerT.ts");){
                    Consumer<String> wD_append = s -> {
                        try {
                            wD.append((CharSequence)s);
                        }
                        catch (IOException e) {
                            this.error("error adding [%s]", s);
                        }
                    };
                    Consumer<String> wT_append = s -> {
                        try {
                            wT.append((CharSequence)s);
                        }
                        catch (IOException e) {
                            this.error("error adding [%s]", s);
                        }
                    };
                    Set<TSType> types = this.enumerateDeclaredPackageAndClass(processingContext);
                    types.addAll(REQUIRED_TYPES);
                    types.addAll(TypescriptConverterStatic.PREDEFINED_TYPES);
                    Map<String, TSType> declaredTypes = types.stream().collect(Collectors.toMap(tt -> tt.getValue().getName(), tt -> tt));
                    String compatibilityOption = processingContext.getOptionMap().getOrDefault("compatibility", "NASHORN").toUpperCase();
                    this.info("COMPATIBILITY WITH [%s]", compatibilityOption);
                    TypescriptConverter converter = new TypescriptConverter(TypescriptConverter.Compatibility.valueOf((String)compatibilityOption));
                    types.stream().filter(tt -> !TypescriptConverterStatic.PREDEFINED_TYPES.contains(tt)).map(tt -> converter.processClass(0, tt, declaredTypes)).forEach(wD_append);
                    wT.append("/// <reference path=\"").append(definitionsFile).append("\"/>").append("\n\n");
                    types.stream().filter(t -> t.isExport()).map(t -> converter.processStatic(t, declaredTypes)).forEach(wT_append);
                }
                if (wD == null) return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (wD == null) throw throwable;
                wD.close();
                throw throwable;
            }
            wD.close();
            return true;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private List<? extends AnnotationValue> getAnnotationValueValue(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        AnnotationValue av = entry.getValue();
        return (List)av.getValue();
    }

    private Set<TSType> enumerateDeclaredPackageAndClass(AbstractProcessorEx.Context processingContext) {
        return processingContext.elementFromAnnotations(Optional.empty()).stream().peek(e -> this.info("Anotation [%s]", e.getKind().name())).filter(e -> ElementKind.PACKAGE == e.getKind() || ElementKind.CLASS == e.getKind()).flatMap(e -> e.getAnnotationMirrors().stream()).peek(m -> this.info("Mirror [%s]", m.toString())).flatMap(am -> am.getElementValues().entrySet().stream().filter(entry -> "declare".equals(String.valueOf(((ExecutableElement)entry.getKey()).getSimpleName())))).flatMap(entry -> this.getAnnotationValueValue((Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)entry).stream()).map(av -> av.getValue()).filter(v -> v instanceof AnnotationMirror).map(v -> (AnnotationMirror)v).map(am -> this.toMapObject((AnnotationMirror)am, () -> TSType.from(Void.class))).collect(Collectors.toSet());
    }
}

