/*
 * Decompiled with CFR 0.152.
 */
package org.carewebframework.help.javahelp;

import java.net.MalformedURLException;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TreeItem;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.beanutils.MethodUtils;
import org.carewebframework.help.HelpTopic;
import org.carewebframework.help.HelpTopicNode;
import org.carewebframework.help.HelpViewType;
import org.carewebframework.help.IHelpView;

public class HelpView
implements IHelpView {
    protected final NavigatorView view;
    private final HelpViewType viewType;
    private final HelpTopicNode rootNode = new HelpTopicNode(null);

    public HelpView(NavigatorView view, HelpViewType viewType) {
        this.view = view;
        this.viewType = viewType;
        this.initTopicTree();
    }

    private void initTopicTree() {
        DefaultMutableTreeNode topicTree = this.getDataAsTree();
        if (topicTree != null) {
            this.initTopicTree(this.rootNode, topicTree.getRoot());
        }
    }

    private void initTopicTree(HelpTopicNode htnParent, TreeNode ttnParent) {
        for (int i = 0; i < ttnParent.getChildCount(); ++i) {
            TreeNode ttnChild = ttnParent.getChildAt(i);
            HelpTopic ht = this.getTopic(ttnChild);
            HelpTopicNode htnChild = new HelpTopicNode(ht);
            htnParent.addChild(htnChild);
            this.initTopicTree(htnChild, ttnChild);
        }
    }

    protected HelpTopic getTopic(TreeNode node) {
        try {
            DefaultMutableTreeNode nd = (DefaultMutableTreeNode)node;
            TreeItem item = (TreeItem)nd.getUserObject();
            Map.ID id = item.getID();
            HelpTopic topic = new HelpTopic(id == null ? null : id.getURL(), item.getName(), this.view.getHelpSet().getTitle());
            if (id != null && this.view.getHelpSet().getKeyData((Object)"topics", id.id) == null) {
                this.view.getHelpSet().setKeyData((Object)"topics", id.id, (Object)topic);
            }
            return topic;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected DefaultMutableTreeNode getDataAsTree() {
        try {
            return (DefaultMutableTreeNode)MethodUtils.invokeMethod((Object)this.view, (String)"getDataAsTree", null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public HelpTopicNode getTopicTree() {
        return this.rootNode;
    }

    public HelpViewType getViewType() {
        return this.viewType;
    }
}

