/*
 * Decompiled with CFR 0.152.
 */
package org.carewebframework.help.javahelp;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.help.GlossaryView;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.IndexView;
import javax.help.Map;
import javax.help.NavigatorView;
import javax.help.TOCView;
import org.carewebframework.help.HelpModule;
import org.carewebframework.help.HelpSetBase;
import org.carewebframework.help.HelpTopic;
import org.carewebframework.help.HelpViewType;
import org.carewebframework.help.IHelpView;
import org.carewebframework.help.javahelp.HelpView;

public class HelpSet_JavaHelp
extends HelpSetBase {
    private static final Map<Class<? extends NavigatorView>, HelpViewType> viewMap = new HashMap<Class<? extends NavigatorView>, HelpViewType>();
    private final HelpSet helpSet;
    private final List<IHelpView> helpViews = new ArrayList<IHelpView>();

    public HelpSet_JavaHelp(HelpModule descriptor) throws MalformedURLException, HelpSetException {
        super(descriptor);
        String url = descriptor.getUrl();
        this.helpSet = new HelpSet(HelpSet_JavaHelp.class.getClassLoader(), url.startsWith("/web/") ? ((Object)((Object)this)).getClass().getResource(url) : new URL(url));
        this.initViews();
    }

    private void initViews() {
        for (NavigatorView view : this.helpSet.getNavigatorViews()) {
            HelpViewType viewType = viewMap.get(view.getClass());
            if (viewType == null) continue;
            this.helpViews.add(new HelpView(view, viewType));
        }
    }

    public String getHomeID() {
        return this.helpSet.getHomeID().id;
    }

    public HelpTopic getTopic(String topicId) {
        HelpTopic topic = (HelpTopic)this.helpSet.getKeyData((Object)"topics", topicId);
        if (topic != null) {
            return topic;
        }
        Map.ID id = Map.ID.create((String)topicId, (HelpSet)this.helpSet);
        try {
            URL url = this.helpSet.getCombinedMap().getURLFromID(id);
            return new HelpTopic(url, topicId, this.helpSet.getTitle());
        }
        catch (Exception e) {
            return null;
        }
    }

    public Collection<IHelpView> getAllViews() {
        return this.helpViews;
    }

    public String getName() {
        return this.helpSet.getTitle();
    }

    static {
        viewMap.put(TOCView.class, HelpViewType.TOC);
        viewMap.put(GlossaryView.class, HelpViewType.GLOSSARY);
        viewMap.put(IndexView.class, HelpViewType.INDEX);
    }
}

