/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S00117", priority=Priority.MAJOR, tags={"convention"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadLocalVariableName_S00117_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00117";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00117");
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                this.scan((Tree)((VariableTree)member).initializer());
                continue;
            }
            this.scan(member);
        }
    }

    public void visitVariable(VariableTree tree) {
        if (!this.pattern.matcher(tree.simpleName().name()).matches()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Rename this local variable name to match the regular expression '" + this.format + "'.");
        }
        super.visitVariable(tree);
    }
}

