/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractDeprecatedChecker;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1724", priority=Priority.MAJOR, tags={"cwe", "obsolete"})
public class ExtendDeprecatedSymbolCheck
extends AbstractDeprecatedChecker {
    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.INTERFACE, (Object)Tree.Kind.ENUM, (Object)Tree.Kind.ANNOTATION_TYPE);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (!this.hasDeprecatedAnnotation(tree)) {
            this.checkSuperTypeDeprecation(classTree.superClass(), false);
            for (Tree superInterface : classTree.superInterfaces()) {
                this.checkSuperTypeDeprecation(superInterface, true);
            }
        }
    }

    private void checkSuperTypeDeprecation(@Nullable Tree superTypeTree, boolean isInterface) {
        Type symbolType;
        if (superTypeTree != null && (symbolType = ((AbstractTypedTree)superTypeTree).getSymbolType()).isTagged(10) && ((Type.ClassType)symbolType).getSymbol().isDeprecated()) {
            this.addIssue(superTypeTree, "\"" + ((Type.ClassType)symbolType).getSymbol().getName() + "\"" + " is deprecated, " + (isInterface ? "implement" : "extend") + " the suggested replacement instead.");
        }
    }
}

