/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2077", priority=Priority.CRITICAL, tags={"cwe", "owasp-top-10", "security", "sql"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SQLInjectionCheck
extends SubscriptionBaseVisitor {
    private String parameterName;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        MethodInvocationTree methodTree = (MethodInvocationTree)tree;
        boolean isHibernateCall = this.isHibernateCall(methodTree);
        if (this.isHibernateCall(methodTree) || this.isExecuteQueryOrPrepareStatement(methodTree)) {
            ExpressionTree arg = (ExpressionTree)methodTree.arguments().get(0);
            this.parameterName = "";
            if (this.isDynamicString(methodTree, arg, null, true)) {
                String message = "\"" + this.parameterName + "\" is provided externally to the method and not sanitized before use.";
                if (isHibernateCall) {
                    message = "Use Hibernate's parameter binding instead of concatenation.";
                }
                this.addIssue((Tree)methodTree, message);
            }
        }
    }

    private boolean isDynamicString(MethodInvocationTree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking) {
        return this.isDynamicString(methodTree, arg, currentlyChecking, false);
    }

    private boolean isDynamicString(MethodInvocationTree methodTree, ExpressionTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        if (arg.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return this.isIdentifierDynamicString(methodTree, (IdentifierTree)arg, currentlyChecking, firstLevel);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            BinaryExpressionTree binaryArg = (BinaryExpressionTree)arg;
            return this.isDynamicString(methodTree, binaryArg.rightOperand(), currentlyChecking) || this.isDynamicString(methodTree, binaryArg.leftOperand(), currentlyChecking);
        }
        if (arg.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        return !arg.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL});
    }

    private boolean isIdentifierDynamicString(MethodInvocationTree methodTree, IdentifierTree arg, @Nullable Symbol currentlyChecking, boolean firstLevel) {
        Tree argEnclosingDeclarationTree;
        Symbol symbol = this.getSemanticModel().getReference(arg);
        if (symbol.equals(currentlyChecking) || this.isConstant(symbol)) {
            return false;
        }
        Tree enclosingBlockTree = this.getSemanticModel().getTree(this.getSemanticModel().getEnv((Tree)methodTree));
        if (enclosingBlockTree.equals(argEnclosingDeclarationTree = this.getSemanticModel().getTree(this.getSemanticModel().getEnv(symbol)))) {
            VariableTree declaration = (VariableTree)this.getSemanticModel().getTree(symbol);
            if (declaration.initializer() != null && this.isDynamicString(methodTree, declaration.initializer(), currentlyChecking)) {
                return true;
            }
            Collection usages = this.getSemanticModel().getUsages(symbol);
            LocalVariableDynamicStringVisitor visitor = new LocalVariableDynamicStringVisitor(symbol, usages, methodTree);
            argEnclosingDeclarationTree.accept((TreeVisitor)visitor);
            return visitor.dynamicString;
        }
        this.parameterName = arg.name();
        return symbol.owner().isKind(16) && !firstLevel;
    }

    private boolean isConstant(Symbol symbol) {
        return symbol.isStatic() && symbol.isFinal();
    }

    private boolean isExecuteQueryOrPrepareStatement(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && (this.isMethodCall("java.sql.Statement", "executeQuery", memberSelectExpressionTree) || this.isMethodCall("java.sql.Connection", "prepareStatement", memberSelectExpressionTree) || this.isMethodCall("java.sql.Connection", "prepareCall", memberSelectExpressionTree));
        }
        return false;
    }

    private boolean isHibernateCall(MethodInvocationTree methodTree) {
        if (methodTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree memberSelectExpressionTree = (MemberSelectExpressionTree)methodTree.methodSelect();
            return !methodTree.arguments().isEmpty() && this.isMethodCall("org.hibernate.Session", "createQuery", memberSelectExpressionTree);
        }
        return false;
    }

    private boolean isMethodCall(String typeName, String methodName, MemberSelectExpressionTree memberSelectExpressionTree) {
        return methodName.equals(memberSelectExpressionTree.identifier().name()) && this.isInvokedOnType(typeName, memberSelectExpressionTree.expression());
    }

    private boolean isInvokedOnType(String type, ExpressionTree expressionTree) {
        Type selectorType = ((AbstractTypedTree)expressionTree).getSymbolType();
        if (selectorType.isTagged(10)) {
            Symbol.TypeSymbol symbol = ((Type.ClassType)selectorType).getSymbol();
            String selector = symbol.owner().getName() + "." + symbol.getName();
            return type.equals(selector) || this.checkInterfaces(type, symbol);
        }
        return false;
    }

    private boolean checkInterfaces(String type, Symbol.TypeSymbol symbol) {
        for (Type interfaceType : symbol.getInterfaces()) {
            Symbol.TypeSymbol interfaceSymbol = ((Type.ClassType)interfaceType).getSymbol();
            if (!type.equals(interfaceSymbol.owner().getName() + "." + interfaceSymbol.getName()) && !this.checkInterfaces(type, interfaceSymbol)) continue;
            return true;
        }
        return false;
    }

    private class LocalVariableDynamicStringVisitor
    extends BaseTreeVisitor {
        private final Collection<IdentifierTree> usages;
        private final MethodInvocationTree methodInvocationTree;
        private final Symbol currentlyChecking;
        private boolean stopInspection;
        boolean dynamicString;

        public LocalVariableDynamicStringVisitor(Symbol currentlyChecking, Collection<IdentifierTree> usages, MethodInvocationTree methodInvocationTree) {
            this.currentlyChecking = currentlyChecking;
            this.stopInspection = false;
            this.usages = usages;
            this.methodInvocationTree = methodInvocationTree;
            this.dynamicString = false;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.stopInspection && tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.usages.contains(tree.variable())) {
                this.dynamicString |= SQLInjectionCheck.this.isDynamicString(this.methodInvocationTree, tree.expression(), this.currentlyChecking);
            }
            super.visitAssignmentExpression(tree);
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.equals(this.methodInvocationTree)) {
                this.stopInspection = true;
            } else {
                super.visitMethodInvocation(tree);
            }
        }
    }
}

