/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaLexer;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1151", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SwitchCaseTooBigCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 5;
    @RuleProperty(defaultValue="5")
    public int max = 5;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaLexer.SWITCH_BLOCK_STATEMENT_GROUP});
    }

    public void visitNode(AstNode node) {
        CaseGroupTree tree = (CaseGroupTree)node;
        for (int i = 0; i < tree.labels().size() - 1; ++i) {
            int caseStartLine = ((JavaTree)tree.labels().get(i)).getLine();
            int nextCaseStartLine = ((JavaTree)tree.labels().get(i + 1)).getLine();
            this.check(caseStartLine, nextCaseStartLine);
        }
        this.check(((JavaTree)Iterables.getLast((Iterable)tree.labels())).getLine(), node.getNextAstNode().getTokenLine());
    }

    private void check(int caseStartLine, int nextCaseStartLine) {
        int lines = Math.max(nextCaseStartLine - caseStartLine, 1);
        if (lines > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "Reduce this switch case number of lines from " + lines + " to at most " + this.max + ", for example by extracting code into methods.", caseStartLine, new Object[0]);
        }
    }
}

