/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Deque;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S128", priority=Priority.CRITICAL, tags={"pitfall"})
@BelongsToProfile(title="Sonar way", priority=Priority.CRITICAL)
public class SwitchCaseWithoutBreakCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S128";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S128");
    private JavaFileScannerContext context;
    private final Deque<CaseGroupTree> invalidCaseGroups = new ArrayDeque<CaseGroupTree>();
    private CaseGroupTree currentTree = null;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.scan((Tree)tree.expression());
        if (!tree.cases().isEmpty()) {
            this.scan(tree.cases().subList(0, tree.cases().size() - 1));
        }
    }

    public void visitCaseGroup(CaseGroupTree tree) {
        this.currentTree = tree;
        this.invalidCaseGroups.push(tree);
        super.visitCaseGroup(tree);
        if (this.invalidCaseGroups.remove(tree)) {
            this.context.addIssue((Tree)Iterables.getLast((Iterable)tree.labels()), this.ruleKey, "End this switch case with an unconditional break, continue, return or throw statement.");
        }
        this.currentTree = this.invalidCaseGroups.peek();
    }

    public void visitBreakStatement(BreakStatementTree tree) {
        super.visitBreakStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitContinueStatement(ContinueStatementTree tree) {
        super.visitContinueStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitReturnStatement(ReturnStatementTree tree) {
        super.visitReturnStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        super.visitThrowStatement(tree);
        this.markSwitchCasesAsCompliant();
    }

    private void markSwitchCasesAsCompliant() {
        this.invalidCaseGroups.remove(this.currentTree);
    }
}

