/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1068", priority=Priority.MAJOR, tags={"unused"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnusedPrivateFieldCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S1068";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S1068");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            this.checkIfUnused((VariableTree)member);
        }
    }

    public void checkIfUnused(VariableTree tree) {
        SemanticModel semanticModel;
        Symbol symbol;
        if (tree.modifiers().modifiers().contains(Modifier.PRIVATE) && !"serialVersionUID".equals(tree.simpleName().name()) && (symbol = (semanticModel = (SemanticModel)this.context.getSemanticModel()).getSymbol((Tree)tree)) != null && semanticModel.getUsages(symbol).isEmpty()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Remove this unused \"" + tree.simpleName() + "\" private field.");
        }
    }
}

