/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannersFactory;

public class SonarComponents
implements BatchExtension {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaFileScannersFactory[] fileScannersFactories;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives) {
        this(fileLinesContextFactory, resourcePerspectives, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, @Nullable JavaFileScannersFactory[] fileScannersFactories) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.fileScannersFactories = fileScannersFactories;
    }

    public FileLinesContextFactory getFileLinesContextFactory() {
        return this.fileLinesContextFactory;
    }

    public ResourcePerspectives getResourcePerspectives() {
        return this.resourcePerspectives;
    }

    public Iterable<JavaFileScanner> createJavaFileScanners() {
        Object result = ImmutableList.of();
        if (this.fileScannersFactories != null) {
            for (JavaFileScannersFactory factory : this.fileScannersFactories) {
                result = Iterables.concat((Iterable)result, (Iterable)factory.createJavaFileScanners());
            }
        }
        return result;
    }
}

