/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.JavaTreeMaker;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

public class VisitorsBridge
extends JavaAstVisitor {
    @Nullable
    private final ResourcePerspectives resourcePerspectives;
    private final JavaTreeMaker treeMaker = new JavaTreeMaker();
    private final List<JavaFileScanner> scanners;

    @VisibleForTesting
    public VisitorsBridge(JavaFileScanner visitor) {
        this(null, Arrays.asList(visitor));
    }

    public VisitorsBridge(@Nullable ResourcePerspectives resourcePerspectives, Iterable visitors) {
        this.resourcePerspectives = resourcePerspectives;
        ImmutableList.Builder scannersBuilder = ImmutableList.builder();
        for (Object visitor : visitors) {
            if (!(visitor instanceof JavaFileScanner)) continue;
            scannersBuilder.add((Object)((JavaFileScanner)visitor));
        }
        this.scanners = scannersBuilder.build();
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (astNode != null) {
            CompilationUnitTree tree = this.treeMaker.compilationUnit(astNode);
            SourceFile sourceFile = this.peekSourceFile();
            JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)sourceFile.getKey());
            Issuable issuable = this.resourcePerspectives == null ? null : (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)sonarFile);
            DefaultJavaFileScannerContext context = new DefaultJavaFileScannerContext(tree, sourceFile, issuable);
            for (JavaFileScanner scanner : this.scanners) {
                scanner.scanFile((JavaFileScannerContext)context);
            }
        }
    }

    private static class DefaultJavaFileScannerContext
    implements JavaFileScannerContext {
        private final CompilationUnitTree tree;
        private final SourceFile sourceFile;
        private final Issuable issuable;

        public DefaultJavaFileScannerContext(CompilationUnitTree tree, SourceFile sourceFile, @Nullable Issuable issuable) {
            this.tree = tree;
            this.sourceFile = sourceFile;
            this.issuable = issuable;
        }

        public CompilationUnitTree getTree() {
            return this.tree;
        }

        public void addIssue(Tree tree, RuleKey ruleKey, String message) {
            Preconditions.checkNotNull((Object)ruleKey);
            Preconditions.checkNotNull((Object)message);
            int line = ((JavaTree)tree).getLine();
            if (this.issuable == null) {
                CheckMessage checkMessage = new CheckMessage((Object)ruleKey, message, new Object[0]);
                checkMessage.setLine(line);
                this.sourceFile.log(checkMessage);
            } else {
                this.issuable.addIssue(this.issuable.newIssueBuilder().ruleKey(ruleKey).line(Integer.valueOf(line)).message(message).build());
            }
        }
    }
}

