/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;

public class SecondPass
implements Symbol.Completer {
    private final SemanticModel semanticModel;
    private final Resolve resolve;

    public SecondPass(SemanticModel semanticModel, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.resolve = resolve;
    }

    @Override
    public void complete(Symbol symbol) {
        if (symbol.kind == 2) {
            this.complete((Symbol.TypeSymbol)symbol);
        } else if (symbol.kind == 16) {
            this.complete((Symbol.MethodSymbol)symbol);
        } else if (symbol.kind == 4) {
            this.complete((Symbol.VariableSymbol)symbol);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void complete(Symbol.TypeSymbol symbol) {
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        if ((symbol.flags() & 0x200) == 0) {
            symbol.members.enter(new Symbol.VariableSymbol(16, "this", symbol.type, (Symbol)symbol));
        }
        if ("".equals(symbol.name)) {
            ((Type.ClassType)symbol.type).interfaces = ImmutableList.of();
            return;
        }
        AstNode astNode = this.semanticModel.getAstNode(symbol).getParent();
        AstNode superclassNode = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        if (superclassNode != null) {
            ((Type.ClassType)symbol.type).supertype = this.resolveType((Resolve.Env)env, (AstNode)superclassNode).type;
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        if (astNode.hasDirectChildren(new AstNodeType[]{JavaGrammar.CLASS_TYPE_LIST})) {
            for (AstNode interfaceNode : astNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE_LIST}).getChildren(new AstNodeType[]{JavaGrammar.CLASS_TYPE})) {
                Type interfaceType = this.castToTypeIfPossible(this.resolveType(env, interfaceNode));
                if (interfaceType == null) continue;
                interfaces.add((Object)interfaceType);
            }
        }
        ((Type.ClassType)symbol.type).interfaces = interfaces.build();
    }

    public void complete(Symbol.MethodSymbol symbol) {
        AstNode identifierNode = this.semanticModel.getAstNode(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        AstNode throwsNode = identifierNode.getNextAstNode().getFirstChild(new AstNodeType[]{JavaKeyword.THROWS});
        ImmutableList.Builder thrown = ImmutableList.builder();
        if (throwsNode != null) {
            for (AstNode qualifiedIdentifier : throwsNode.getNextAstNode().getChildren(new AstNodeType[]{JavaGrammar.QUALIFIED_IDENTIFIER})) {
                Type thrownType = this.castToTypeIfPossible(this.resolveType(env, qualifiedIdentifier));
                if (thrownType == null) continue;
                thrown.add((Object)((Type.ClassType)thrownType).symbol);
            }
        }
        symbol.thrown = thrown.build();
        if ("<init>".equals(symbol.name)) {
            return;
        }
        AstNode typeNode = identifierNode.getPreviousAstNode();
        Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaKeyword.VOID, JavaGrammar.TYPE}));
        AstNode classTypeNode = typeNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE});
        if (classTypeNode == null) {
            return;
        }
        Type type = this.castToTypeIfPossible(this.resolveType(env, classTypeNode));
        if (type != null) {
            symbol.type = ((Type.ClassType)type).symbol;
        }
    }

    public void complete(Symbol.VariableSymbol symbol) {
        AstNode typeNode;
        AstNode identifierNode = this.semanticModel.getAstNode(symbol);
        if (identifierNode.getParent().is(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
            typeNode = identifierNode.getFirstAncestor((AstNodeType)JavaGrammar.VARIABLE_DECLARATORS).getPreviousAstNode();
            Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaGrammar.TYPE}));
        } else if (identifierNode.getParent().is(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID})) {
            typeNode = identifierNode.getParent().getPreviousAstNode();
            if (typeNode.is(new AstNodeType[]{JavaPunctuator.ELLIPSIS})) {
                typeNode = typeNode.getPreviousAstNode();
            }
            Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaGrammar.TYPE, JavaGrammar.CLASS_TYPE, JavaGrammar.CATCH_TYPE}));
        } else {
            if (identifierNode.getParent().is(new AstNodeType[]{JavaGrammar.ENUM_CONSTANT})) {
                this.semanticModel.getEnv(symbol).enclosingClass();
                return;
            }
            if (identifierNode.getParent().is(new AstNodeType[]{JavaGrammar.CONSTANT_DECLARATOR})) {
                typeNode = identifierNode.getFirstAncestor((AstNodeType)JavaGrammar.CONSTANT_DECLARATORS_REST).getPreviousAstNode().getPreviousAstNode();
                Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaGrammar.TYPE}));
            } else if (identifierNode.getParent().is(new AstNodeType[]{JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL, JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST})) {
                typeNode = identifierNode.getPreviousAstNode();
                Preconditions.checkState((boolean)typeNode.is(new AstNodeType[]{JavaGrammar.TYPE}));
            } else {
                throw new IllegalStateException();
            }
        }
        this.resolveVariableType(symbol, typeNode);
    }

    private void resolveVariableType(Symbol.VariableSymbol symbol, AstNode typeNode) {
        if (typeNode.is(new AstNodeType[]{JavaGrammar.TYPE})) {
            if ((typeNode = typeNode.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_TYPE})) == null) {
                return;
            }
        } else if (!typeNode.is(new AstNodeType[]{JavaGrammar.CLASS_TYPE})) {
            if (typeNode.is(new AstNodeType[]{JavaGrammar.CATCH_TYPE})) {
                return;
            }
            throw new IllegalArgumentException();
        }
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        symbol.type = this.castToTypeIfPossible(this.resolveType(env, typeNode));
    }

    private Symbol resolveType(Resolve.Env env, AstNode astNode) {
        Preconditions.checkArgument((boolean)astNode.is(new AstNodeType[]{JavaGrammar.CLASS_TYPE, JavaGrammar.QUALIFIED_IDENTIFIER}));
        env = env.dup();
        List identifiers = astNode.getChildren(new AstNodeType[]{JavaTokenType.IDENTIFIER});
        Symbol site = this.resolve.findIdent(env, ((AstNode)identifiers.get(0)).getTokenValue(), 3);
        this.associateReference((AstNode)identifiers.get(0), site);
        for (AstNode identifierNode : identifiers.subList(1, identifiers.size())) {
            if (site.kind >= 64) {
                return site;
            }
            String name = identifierNode.getTokenValue();
            if (site.kind == 1) {
                env.packge = (Symbol.PackageSymbol)site;
                site = this.resolve.findIdentInPackage(env, site, name, 3);
            } else {
                env.enclosingClass = (Symbol.TypeSymbol)site;
                site = this.resolve.findMemberType(env, (Symbol.TypeSymbol)site, name, (Symbol.TypeSymbol)site);
            }
            this.associateReference(identifierNode, site);
        }
        return site;
    }

    private Type castToTypeIfPossible(Symbol symbol) {
        return symbol instanceof Symbol.TypeSymbol ? ((Symbol.TypeSymbol)symbol).type : null;
    }

    private void associateReference(AstNode astNode, Symbol symbol) {
        if (symbol.kind < 64 && this.semanticModel.getAstNode(symbol) != null) {
            this.semanticModel.associateReference(astNode, symbol);
        }
    }
}

