/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="MultilineStringLiterals", priority=Priority.BLOCKER)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class MultilineStringLiteralsCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).stringLiteral});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.getTokenValue().contains("\n")) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid multiline string literals.", astNode, new Object[0]);
        }
    }
}

