/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="UnreachableCode", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnreachableCodeCheck
extends SquidCheck<EcmaScriptGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).breakStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).returnStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).continueStatement, ((EcmaScriptGrammar)this.getContext().getGrammar()).throwStatement});
    }

    public void visitNode(AstNode node) {
        AstNode v;
        while (node.getParent().is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).statement}) || node.getParent().is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).sourceElement})) {
            node = node.getParent();
        }
        if (node.nextSibling() != null && !(v = node.nextSibling()).is(new AstNodeType[]{((EcmaScriptGrammar)this.getContext().getGrammar()).elseClause})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement can't be reached and so start a dead code block.", v, new Object[0]);
        }
    }
}

