/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="CurlyBraces", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AlwaysUseCurlyBracesCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.FOR_IN_STATEMENT, EcmaScriptGrammar.FOR_STATEMENT, EcmaScriptGrammar.WHILE_STATEMENT, EcmaScriptGrammar.DO_WHILE_STATEMENT, EcmaScriptGrammar.ELSE_CLAUSE});
    }

    public void visitNode(AstNode astNode) {
        List statements = astNode.getChildren(new AstNodeType[]{EcmaScriptGrammar.STATEMENT});
        for (AstNode statement : statements) {
            if (statement.getChild(0).is(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT}) && statement.getPreviousSibling().is(new AstNodeType[]{EcmaScriptKeyword.ELSE}) || statement.getChild(0).is(new AstNodeType[]{EcmaScriptGrammar.BLOCK})) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Missing curly brace.", astNode, new Object[0]);
            break;
        }
    }
}

