/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="AssignmentWithinCondition", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AssignmentWithinConditionCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.DO_WHILE_STATEMENT, EcmaScriptGrammar.WHILE_STATEMENT, EcmaScriptGrammar.FOR_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode conditionNode = astNode.getFirstChild(new AstNodeType[]{EcmaScriptGrammar.CONDITION});
        if (conditionNode != null && conditionNode.getChild(0).getFirstChild(new AstNodeType[]{EcmaScriptGrammar.ASSIGNMENT_EXPRESSION}) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this assignment from the expression.", conditionNode, new Object[0]);
        }
    }
}

