/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Map;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.model.BlockTree;
import org.sonar.javascript.model.EmptyStatementTree;
import org.sonar.javascript.model.LabelledStatementTree;
import org.sonar.javascript.model.StatementTree;
import org.sonar.javascript.model.TreeVisitor;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="OneStatementPerLine", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class OneStatementPerLineCheck
extends SquidCheck<LexerlessGrammar>
implements TreeVisitor {
    private final Map<Integer, Integer> statementsPerLine = Maps.newHashMap();

    public void visitFile(AstNode astNode) {
        this.statementsPerLine.clear();
    }

    public void visit(StatementTree statementTree) {
        if (!(statementTree.is(BlockTree.class) || statementTree.is(EmptyStatementTree.class) || statementTree.is(LabelledStatementTree.class))) {
            int line = statementTree.getLine();
            if (!this.statementsPerLine.containsKey(line)) {
                this.statementsPerLine.put(line, 0);
            }
            this.statementsPerLine.put(line, this.statementsPerLine.get(line) + 1);
        }
    }

    public void leaveFile(AstNode astNode) {
        for (Map.Entry<Integer, Integer> statementsAtLine : this.statementsPerLine.entrySet()) {
            if (statementsAtLine.getValue() <= 1) continue;
            this.getContext().createLineViolation((CodeCheck)this, "At most one statement is allowed per line, but {0} statements were found on this line.", statementsAtLine.getKey().intValue(), new Object[]{statementsAtLine.getValue()});
        }
    }
}

