/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnreachableCode", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnreachableCodeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.RETURN_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT, EcmaScriptGrammar.THROW_STATEMENT});
    }

    public void visitNode(AstNode node) {
        AstNode v;
        while (node.getParent().is(new AstNodeType[]{EcmaScriptGrammar.STATEMENT}) || node.getParent().is(new AstNodeType[]{EcmaScriptGrammar.SOURCE_ELEMENT})) {
            node = node.getParent();
        }
        if (node.getNextSibling() != null && !(v = node.getNextSibling()).is(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE})) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement can't be reached and so start a dead code block.", v, new Object[0]);
        }
    }
}

