/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="UnreachableCode", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class UnreachableCodeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.RETURN_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT, EcmaScriptGrammar.THROW_STATEMENT});
    }

    public void visitNode(AstNode node) {
        while (node.getParent().is(new AstNodeType[]{EcmaScriptGrammar.STATEMENT})) {
            node = node.getParent();
        }
        AstNode nextStatement = node.getNextSibling();
        if (UnreachableCodeCheck.isUnReachableCode(nextStatement)) {
            this.getContext().createLineViolation((CodeCheck)this, "This statement can't be reached and so start a dead code block.", nextStatement, new Object[0]);
        }
    }

    public static boolean isUnReachableCode(AstNode node) {
        return node != null && !node.is(new AstNodeType[]{EcmaScriptGrammar.ELSE_CLAUSE}) && !node.is(new AstNodeType[]{EcmaScriptGrammar.DECLARATION});
    }
}

