/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.interfaces.Tree;

@Rule(key="S1067", priority=Priority.MAJOR, tags={"brain-overload"})
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class ExpressionComplexityCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT = 3;
    @RuleProperty(defaultValue="3")
    public int max = 3;
    private List<ExpressionComplexity> statementLevel = Lists.newArrayList();
    private static final Tree.Kind[] SCOPES = new Tree.Kind[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION};
    private static final Tree.Kind[] CONDITIONAL_EXPRS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR};

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object[])CONDITIONAL_EXPRS).add((Object[])SCOPES).build();
    }

    public void visitFile(Tree scriptTree) {
        this.statementLevel.clear();
        this.statementLevel.add(new ExpressionComplexity());
    }

    public void visitNode(Tree tree) {
        if (tree.is(CONDITIONAL_EXPRS)) {
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).incrementNestedExprLevel();
            ((ExpressionComplexity)Iterables.getLast(this.statementLevel)).increaseOperatorCounter(1);
        } else if (tree.is(SCOPES)) {
            this.statementLevel.add(new ExpressionComplexity());
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(CONDITIONAL_EXPRS)) {
            ExpressionComplexity currentExpression = (ExpressionComplexity)Iterables.getLast(this.statementLevel);
            currentExpression.decrementNestedExprLevel();
            if (currentExpression.isOnFirstExprLevel()) {
                if (currentExpression.getExprNumberOfOperator() > this.max) {
                    this.addIssue(tree, "Reduce the number of conditional operators (" + currentExpression.getExprNumberOfOperator() + ") used in the expression (maximum allowed " + this.max + ").");
                }
                currentExpression.resetExprOperatorCounter();
            }
        } else if (tree.is(SCOPES)) {
            this.statementLevel.remove(this.statementLevel.size() - 1);
        }
    }

    public static class ExpressionComplexity {
        private int nestedLevel = 0;
        private int counterOperator = 0;

        public void increaseOperatorCounter(int nbOperator) {
            this.counterOperator += nbOperator;
        }

        public void incrementNestedExprLevel() {
            ++this.nestedLevel;
        }

        public void decrementNestedExprLevel() {
            --this.nestedLevel;
        }

        public boolean isOnFirstExprLevel() {
            return this.nestedLevel == 0;
        }

        public int getExprNumberOfOperator() {
            return this.counterOperator;
        }

        public void resetExprOperatorCounter() {
            this.counterOperator = 0;
        }
    }
}

